<?php

/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

	/*	
	*	Chapter Ornaments File
	*	---------------------------------------------------------------------
	* 	@version	1.0
	* 	@author		SynapseIndia
	* 	@link		http://www.synapseindia.com
	*	---------------------------------------------------------------------
	*	This file is used to manage book chapter ornaments.
	*	---------------------------------------------------------------------
	*/
?>
<div class="styles-container" id="book-style-text">

<p>This section contains fonts defined in the main FONTS tab above. Add custom typefaces there as needed. Adjust built-in styles on a per-book basis here. Use the shortcut links to the right of the page diagram  to load styles into the Style Editor at the bottom of the screen.</p>
	<div class="text_styles_full">

		<img src="<?php echo (!empty($data['text_style']['orn-style-val'])) ? $data['text_style']['orn-style-val'] :PUBML_BASE_URL.'/images/section_ornament_placeholder.png'; ?>" style="float: left;left: 420px; margin-top: -4%;position: relative; top: 130px;" class="chap-orn-img" width="80" height="80" />

		<img id="Image-Maps_9201312160601196" src="<?php echo PUBML_BASE_URL;?>/images/text_styles_full.jpg" usemap="#Image-Maps_9201312160601196" border="0" width="780" height="551" alt="" />

		<map id="_Image-Maps_9201312160601196" name="Image-Maps_9201312160601196">

			<area shape="rect" onClick="page_style_change('Running Head');" coords="668,50,775,4" href="javascript:void(0);" alt="Running Head" title="Running Head"    />

			<area shape="rect" onClick="page_style_change('Chapter Ornament');" coords="668,107,775,157" href="javascript:void(0);" alt="Chapter Ornament" title="Chapter Ornament"    />

			<area shape="rect" onClick="page_style_change('Headline (Title)');" coords="653,174,760,224" href="javascript:void(0);" alt="headline" title="headline"    />

			<area shape="rect" onClick="page_style_change('SubHeadline (Subtitle)');" coords="668,232,775,282" href="javascript:void(0);" alt="sub headline" title="sub headline"    />

			<area shape="rect" onClick="page_style_change('Epigram/Quotation');" coords="668,289,775,339" href="javascript:void(0);" alt="Epigram" title="Epigram"    />

			<area shape="rect" onClick="page_style_change('Epigram Byline');" coords="668,388,775,438" href="javascript:void(0);" alt="Epigram byline" title="Epigram byline"    />

			<area shape="rect" onClick="page_style_change('Body Text');" coords="668,476,775,526" href="javascript:void(0);" alt="Body text" title="Body text"    />

		</map>

	</div>

	<div>

		<h3 style="float: left;margin-top: 1%;">Chapter Ornament</h3> 

		<span style="float: left;" id="styles_text" class="help openhelp"><img src="<?php echo PUBML_BASE_URL;?>/images/help.png"></span>

	</div>
	<?php
		$existing_ornament = PUBML_BASE_URL.'/images/section_ornament_placeholder.png';
		if($data['text_style']['orn-style-val']!= $existing_ornament){
			$display ='block';
			$dis = 'none';
		}
		else{
				$display ='none';
				$dis ='block';
		}
	?>


	<span style="margin-top:1%;"><a style="display:<?php echo $dis; ?>;" class="button button-primary button-large" id="upload-ornament-link" href="#">Add a Custom Chapter Ornament</a>&nbsp;&nbsp;&nbsp;&nbsp;<a style="background:#BD1A1B;width:46%;display:<?php echo $display; ?>;" href="javascript:void(0);" class="del-chap-ornament button button-primary button-large">Delete Custom Chapter Ornament</a></span>



	<input type="hidden" id="orn-style-val" name="text_style[orn-style-val]"  value="<?php echo (!empty($data['text_style']['orn-style-val'])) ? $data['text_style']['orn-style-val'] :PUBML_BASE_URL.'/images/section_ornament_placeholder.png'; ?>" />
	<input type="hidden" id="def-orn-style-val" name="text_style[def-orn-style-val]"  value="<?php echo (!empty($data['text_style']['def-orn-style-val'])) ? $data['text_style']['def-orn-style-val'] :PUBML_BASE_URL.'/images/section_ornament_placeholder.png'; ?>" />		





	<div>

		<h3 style="float: left;margin-top: 1%;">Style Editor</h3><span style="float: left;" id="styles_text" class="help openhelp"><img src="<?php echo PUBML_BASE_URL;?>/images/help.png"></span><br/><br/>

		<p>Select a character/paragraph style menu below to edit.<br/>

			Enter a new style name and description to create a custom style.

		</p>

		<?php echo $styles_select = pubml_styles_dropdown($name = 'style',$bid=$book_id);
		
		?>
	<a  style="display:none;" class="button button-primary button-large" id="del-style" href="javascript:void(0);">Delete Style</a>
	<a  class="button button-primary button-large" id="add-new-style" href="javascript:void(0);">New Style</a>
	</div>
	<div class="headline-add-data">

		<div class="h-one">	

			<p>Style Name (rename to create a custom style)</p>

    		<input type="text" name="style_name_val" id="style-name-val" value="" />	
			
			<input type="hidden" name="add-new-style-val" id="add-new-style-val"  value="0" />
			<input type="hidden" name="style-slug" id="style-slug"  value="" />
			<input type="hidden" name="hide_from_section_editor" id="hide_from_section_editor"  value="false" /> 
			
			<p>Style Description</p>

			<textarea style="height:100px;" class="style-desc" name="style-desc" cols="50">Headline Data</textarea> 	

		</div>

		<div class="h-two">

			 <p>Style Preview (type in this box to see text rendered with your chosen style options)</p>

			<textarea style="height:160px;display:none;" class="style-prev" name="style-prev"  cols="56">Headline Data</textarea>
			<div style="height:160px;background:#fff;" contenteditable="true" id="style_prev" class="style-prev">Headline Data</div>

		</div>
	<div width="100%" style="margin:0; padding:0;font-size:13px;font-family:'Gill Sans', 'Gill Sans MT', 'Myriad Pro', 'DejaVu Sans Condensed', Helvetica, Arial, sans-serif;color:#900;">Use the &quot;Readers Choice&quot; Font to allow your reader to choose the typeface for a particular style in your &lt;PubML&gt;™ eBook's Settings panel.</div>
	  <div class="h-three">

			<span class="line-contain">

				<p>Fonts (use the Fonts tab to add fonts to this menu)</p>

				<?php echo $fonts_select = pubml_fonts_dropdown('text-font-menu');?>

				<input type="text" id="style-font-val" value="" />px	

			</span>

			<span class="line-container">

				<div><p>Line Height</p>

				<input type="text" id="line-height-val" value="" />px</div>
				
				<div><p>First Line Indent</p>

				<input type="text" id="line-indent-val" value="" />px</div>

			</span>

			<span class="line-contain">

				<div><p>Left Margin</p>

				<input type="text" id="lmargin-val" value="" />px</div>

				<div><p>Right Margin</p>

				<input type="text" id="rmargin-val" value="" />px</div>

			</span>

		</div>



		<div class="h-four">

			<span class="tstyle-one">

				<div>

					<p>Default Style</p>

					<select name="text-font-weight" class="text-font-weight">

						<option value="bold">Bold</option>

						<option value="italic">Italic</option>

						<option value="normal">Normal</option>

					</select>

				</div>

				<div style="margin-top:10%;">

					<p><input type="checkbox" class="hypen-val"  name="hypen-val" value="on" /> Hyphenation </p>

				</div>

			</span>

			<span class="tstyle-two">

				<div style="width:35%;margin-top:10%;">

					<p><input type="checkbox" class="runt-val"  name="runt-val" value="on" /> Runt Control </p>

				</div>

				<div style="width:65%;">

					<p>Justify/Align</p>

					<div>

						<select class="align-val"  name="align-val">

							<option value="justify">Justify</option>

							<option value="left">Left</option>

							<option value="center" selected="selected">Center</option>

							<option value="right">Right</option>

						</select>

					</div>

				</div>

			</span>

			<span class="tstyle-three">

				<div>

					<p>Top Margin</p>

					<input type="text" id="lines-before" value="" />px

				</div>

				<div>

					<p>Bottom Margin</p>

					<input type="text" id="lines-after" value="" />px

				</div>

			</span>

		</div>

		<div style="margin-top:2%;">
		<a style="float:left;" class="button button-primary button-large" id="restore-style" href="javascript:void(0);">Restore Default Settings</a>
		<span style="display:none;float:left;clear: both;margin: 3%;padding: 10px 0;text-align: center;" class="msg-text"></span>		
		<a  style="float:right;margin-right:2%;" class="button button-primary button-large" id="save-style" href="javascript:void(0);">Save Style</a></div>

	</div>





</div>
<script>
/* Validation controller */
jQuery(function(){
jQuery('#new_book_styles').validate();
	jQuery.validator.addClassRules({
		style_name_val: {
			 required: true
		}
	});
});
</script>