<?php
/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

	/*	
	*	Layouts File for styles section
	*	---------------------------------------------------------------------
	* 	@version	1.0
	* 	@author		SynapseIndia
	* 	@link		http://www.synapseindia.com
	*	---------------------------------------------------------------------
	*	This file is used to manage book layout styles.
	*	---------------------------------------------------------------------
	*/
?>
<div class="styles-container" id="book-style-layout">
	<div>
		<h3><span class="help openhelp" id="styles_layout" style="width:auto;"><img src="<?php echo PUBML_BASE_URL;?>/images/help.png"></span>Page Proportions
		</h3>

		<div style="margin-left:1%;margin-top: 2%;width: 75%;">Web books are read on a variety of devices with different screen sizes and orientations. Start with the templates provided to choose display margins for various screens and then customize your dimensions to suit your needs.<br/><br/>Emulate standard page proportions or choose custom measurements.</div>

		<?php
			$checked = (@$option == $data['layout']['book-page-size'])? ' checked="checked"' : '';
			$prop1 = 'unchecked';
			$prop2 = 'unchecked';
			$prop3 = 'unchecked';
			$prop4 = 'unchecked';
			$prop5 = 'unchecked';

			if (isset($data)) {
				$selected_radio = $data['layout']['book-page-size'];
				if ($selected_radio == '69') {
				$prop1 = 'checked';
				}
				else if ($selected_radio == '57') {
				$prop2 = 'checked';
				}
				else if ($selected_radio == '11') {
				$prop3 = 'checked';
				}
				else if ($selected_radio == 'golden') {
				$prop4 = 'checked';
				}
				else if ($selected_radio == 'custom') {
				$prop5 = 'checked';
				}
			}
		?>

			<div class="proportion-data">
				<div class="prop-first"><h5>Choose Proportions</h5></div>
			
				<div class="prop-two">
					<div><span class="psize"><img src="<?php echo PUBML_BASE_URL;?>/images/layout_6-9_proportions.png" alt=""/></span></span><input <?php echo $prop1; ?> checked="checked" type="radio" class="prop-val" name="layout[book-page-size]" value="69" /></span></div>

					<div><span class="psize"><img src="<?php echo PUBML_BASE_URL;?>/images/layout_5-7_proportions.png" alt=""/></span><span><input type="radio" <?php echo $prop2; ?>  class="prop-val" name="layout[book-page-size]" value="57" /></span></div>

					<div><span class="psize"><img src="<?php echo PUBML_BASE_URL;?>/images/layout_1-1_proportions.png" alt=""/></span><span><input type="radio" <?php echo $prop3; ?>  class="prop-val" name="layout[book-page-size]" value="11" /></span></div>

					<div><span class="psize"><img src="<?php echo PUBML_BASE_URL;?>/images/layout_golden_proportions.png" alt=""/></span><span><input type="radio" <?php echo $prop4; ?> class="prop-val" name="layout[book-page-size]" value="golden" /></span></div>

					<div><span class="psize" id="custom-psize"><img src="<?php echo PUBML_BASE_URL;?>/images/layout_custom_proportions.png" alt=""/></span><span><input class="prop-val" <?php echo $prop5; ?>  type="radio" name="layout[book-page-size]" value="custom" /></span></div>
				</div>

				<div class="prop-three">
					<div>
						<span>Width</span>
							<input type="text" name="layout[layout-img-width]" id="layout-img-width" value="<?php echo (!empty($data['layout']['layout-img-width'])) ? $data['layout']['layout-img-width'] : ''; ?>" />
						<span>Height</span>
							<input type="text" name="layout[layout-img-height]" id="layout-img-height" value="<?php echo (!empty($data['layout']['layout-img-height'])) ? $data['layout']['layout-img-height'] : ''; ?>" />
					</div>
					<div>Specify height and width as a ratio. No units required.<br/>For example, enter 6 and 9 to emulate 6" x 9" book.</div>
				</div>
			</div>

	</div>

	<div>
		<h3><span class="help openhelp" id="styles_layout" style="width:auto;"><img src="<?php echo PUBML_BASE_URL;?>/images/help.png"></span>Page Margins</h3>
		

	  <?php
			$margin_checked = (@$option == $data['layout']['book-page-margin'])? ' checked="checked"' : '';
			$pmargin1 = 'unchecked';
			$pmargin2 = 'unchecked';
			$pmargin3 = 'unchecked';
				if (isset($data)) {
					$selected_radio = $data['layout']['book-page-margin'];
					if ($selected_radio == 'classic') {
					$pmargin1 = 'checked';
					}
					else if ($selected_radio == 'trade') {
					$pmargin2 = 'checked';
					}
					else if ($selected_radio == 'custom') {
					$pmargin3 = 'checked';
					}
				}
		?>

			<div class="pmargin-data">
				<div class="pmargin-radios">

					<div><span class="psize"><img src="<?php echo PUBML_BASE_URL;?>/images/layout_classic.png" alt=""/></span><span><input  <?php echo $pmargin1;?> checked="checked" type="radio" class="pmargin-val" name="layout[book-page-margin]" value="classic" /></span><span>Classic Book<br/>Van de Graaf Canon<span></div>

					<div><span class="psize"><img src="<?php echo PUBML_BASE_URL;?>/imag

					es/layout_trade_margins.png" alt=""/></span><span><input type="radio" <?php echo $pmargin2;?> class="pmargin-val" name="layout[book-page-margin]" value="trade" /></span><span>Trade Book<br/>Half-Inch Margins</span></div>

					<div><span class="psize" id="custom-pmargin"><img src="<?php echo PUBML_BASE_URL;?>/images/layout_custom_margins.png" alt=""/></span><span><input <?php echo $pmargin3;?> type="radio" class="pmargin-val" name="layout[book-page-margin]" value="custom" /></span><span>Custom<span></div>

				</div>

				<div class="pmargin-custom">

					<div><span>Top Margin</span><span style="width:20% !important;"><input type="text" name="layout[layout-top-margin]" id="layout-top-margin" value="<?php echo (!empty($data['layout']['layout-top-margin'])) ? $data['layout']['layout-top-margin'] : ''; ?>" /></span></span><span>% of page height</span></div>

					<div><span>Bottom Margin</span><span style="width:20% !important;"><input type="text" name="layout[layout-bottom-margin]" id="layout-bottom-margin" value="<?php echo (!empty($data['layout']['layout-bottom-margin'])) ? $data['layout']['layout-bottom-margin'] : ''; ?>" /></span><span>% of page height</span></div>

					<div><span>Outside Margin</span><span style="width:20% !important;"><input type="text" name="layout[layout-out-margin]"  id="layout-out-margin" value="<?php echo (!empty($data['layout']['layout-out-margin'])) ? $data['layout']['layout-out-margin'] : ''; ?>" /></span><span>% of page height</span></div>

					<div><span>Inside Margin</span><span style="width:20% !important;"><input type="text" id="layout-in-margin" name="layout[layout-in-margin]" value="<?php echo (!empty($data['layout']['layout-in-margin'])) ? $data['layout']['layout-in-margin'] : ''; ?>" /></span><span> % of page height<span></div>

					<div>Enter "px" after a value to use a fixed measurement instead of a %</div>

				</div>

			</div>

	</div>

</div> <!-- styles-container -->