<?php
/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/


	/*	

	*	Footnotes File

	*	---------------------------------------------------------------------

	* 	@version	1.0

	* 	@author		SynapseIndia

	* 	@link		http://www.synapseindia.com

	*	---------------------------------------------------------------------

	*	This file is used to manage book footnotes.

	*	---------------------------------------------------------------------

	*/

	

$book_slug = @$_GET['book'];

$Book = get_term_by('slug', $book_slug, 'book');

$book_id=$Book->term_id;

$book_meta = get_option( "taxonomy_$book_id");

$book_author = $book_meta['contributor1last']." ".$book_meta['contributor1first']." ".$book_meta['contributor1middle'];

$edition_notes = ($book_meta['edition_notes']) ? $book_meta['edition_notes'] : '&nbsp;';

?>

<div id="book_meta">

<div class="screen_icon"><img src="<?php echo PUBML_BASE_URL;?>/images/photonotes_icon_64x64.png" width="64" height="64"  alt=""/></div>

<h2>Footnotes For <i><?php echo $Book->name;?><span style="font-size: 14px;font-style: normal;font-weight: bold;margin: 0;">&nbsp;(<?php echo $edition_notes ; ?>)</span></i><span class="help openhelp" id="photo_footnotes" style="margin-left:10px"><img style="vertical-align:middle ! important;" src="<?php echo PUBML_BASE_URL;?>/images/help.png"></span></h2>



<!--TABS------------------------------>

<div class="primary_menu_bar">

	<?php fn_custom_tabs_main('My Books');?>

</div>

<div class="clear"></div>

<div class="secondary_menu_bar">

	<?php fn_custom_tabs_toc('Footnotes');?>

</div>



	<div class="content_container">

	

	

	<div class="settings_content">

		<div class="row-actionss" style="float:left;margin-right: 20px;width:49%;">

			PubML PhotoNotes allow you to add "footnotes" anywhere in your text. <br/>Instead of appearing at the bottom of a page, PhotoNotes pop up over the text as explanatory "cards."

		</div>

		<div class="row-actionss"  style="float:right;width:48%">

			Preview, modify, or delete Photonotes using icons to the right of each note.

		</div>

	</div>

	<div class="clear"></div>

	

	

	<div class="top_btn_right">

		<a href="admin.php?page=book-new-footnote&book=<?php echo $Book->slug;?>" class="button button-primary button-large">Add Footnote</a>

	</div>



	<table class="pub_tbl" cellpadding="0" cellspacing="0">

		<div class="tbl_th">

			<tr>

				<th width="14%">Footnote Image</th>

				<th width="20%">Slug(Footnote Name)</th>

				<th width="50%">Footnote text</th>

				<th width="5%">View</th>

				<th width="5%">Edit</th>

				<th width="5%">Delete</th>

			</tr>

		</div>



		<!-- Getting the list of books -->

		<?php

			$chapters = query_posts(array( 

				'post_type' => 'pubml_footnotes',

				'showposts' => -1,

				'meta_query' => array(

					array(

						'key' => 'book',

						'value' => $Book->term_id,

					)

				),

				'orderby' => 'title',

				'order' => 'ASC' )

			);



			foreach ($chapters as $chapter) {

				//get_the_post_thumbnail($chapter->ID, 'thumbnail');

				$custom_footnote_image = get_post_meta($chapter->ID,'custom_footnote_image',true);

				$footnote_image = ($custom_footnote_image)? $custom_footnote_image : PUBML_BASE_URL.'/images/default_note_bg.jpg';

		?>

				<div class="tbl_td">

				<tr id="footnote_<?php echo $chapter->ID;?>">

					<td class="feature_image"><img src="<?php echo $footnote_image;?>"></td>

					<td><?php echo $chapter->post_name;?></td>

					<td><?php echo "<strong>".$chapter->post_title."</strong> - ".$chapter->post_content;?></td>

					<td><a href="javascript:getFootnote('<?php echo $chapter->post_name;?>')" class="footnote"><img src="<?php echo PUBML_BASE_URL;?>/images/search.png" class="tbl_icon"></a></td>

					<td class="name column-name"><a href="admin.php?page=book-new-footnote&footnote=<?php echo $chapter->ID;?>&book=<?php echo $book_slug;?>&action=edit"><img src="<?php echo PUBML_BASE_URL;?>/images/edit.png" class="tbl_icon"></a></td>

					<td><a href="JavaScript:void(0);" id="<?php echo $chapter->ID;?>" class="delete-chapter-post"><img src="<?php echo PUBML_BASE_URL;?>/images/delete.png" class="tbl_icon"></a></td>

					

				</tr>

				</div>	

<?php

			}



?>

	</table>

	</div>

</div>

<div id="footnote_overlay"></div>

<div id="footnote" style="display: none;"></div>



<!-- Script to remove section -->

<?php function add_js_footnote(){ ?>

<script type="text/javascript">

/* Preview the footnote */

jQuery(document).ready(function($) {

$('#footnote_overlay').click(function() {

	hideFootnote();

});



/* Removing the footnote */

	$(".delete-chapter-post" ).click(function() {

	var postid = $(this).attr('id');

	var data = {

		action: 'delete_post_custom',

		post_id: postid

	};

$("#footnote_"+postid).css('background-color','#FF0000');

if(confirm("Are you sure want to remove this footnote?")){

		// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php

		$.post(ajaxurl, data, function(response) {

				$("#footnote_"+response.post_id).remove();



		}, "json");

} else {

$("#footnote_"+postid).css('background-color','#EEE');

}

	});

});

</script>

<?php } 

add_action('admin_print_footer_scripts', 'add_js_footnote');

?>

