<?php

/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/


/**
 * PubML init Functions 
 *
 * General init functions, variable and Array().
 *
 * @author 		SynapseIndia
 * @category 	Core
 * @link		http://www.pubml.com
 * @package 	PubML/inc/INIT 
 * @version     0.0.1
 */	

	// PubML Language Array
	$pubml_language_array = array(
				"en"  => "English",
				"aa"  => "Afar",
				"ab"  => "Abkhazian",
				"af"  => "Afrikaans",
				"ak"  => "Akan",
				"sq"  => "Albanian",
				"am"  => "Amharic",
				"ar"  => "Arabic",
				"an"  => "Aragonese",
				"hy"  => "Armenian",
				"as"  => "Assamese",
				"av"  => "Avaric",
				"ae"  => "Avestan",
				"ay"  => "Aymara",
				"az"  => "Azerbaijani",
				"ba"  => "Bashkir",
				"bm"  => "Bambara",
				"eu"  => "Basque",
				"be"  => "Belarusian",
				"bn"  => "Bengali",
				"bh"  => "Bihari",
				"bi"  => "Bislama",
				"bo"  => "Tibetan",
				"bs"  => "Bosnian",
				"br"  => "Breton",
				"bg"  => "Bulgarian",
				"my"  => "Burmese",
				"ca"  => "Catalan",
				"cs"  => "Czech",
				"ch"  => "Chamorro",
				"ce"  => "Chechen",
				"zh"  => "Chinese",
				"cu"  => "Church Slavic, Old Slavonic",
				"cv"  => "Chuvash",
				"kw"  => "Cornish",
				"co"  => "Corsican",
				"cr"  => "Cree",
				"cy"  => "Welsh",
				"cs"  => "Czech",
				"da"  => "Danish",
				"de"  => "German",
				"dv"  => "Divehi, Dhivehi, Maldivian",
				"nl"  => "Dutch, Flemish",
				"dz"  => "Dzongkha",
				"el"  => "Greek, Modern (1453-)",
				"eo"  => "Esperanto",
				"et"  => "Estonian",
				"eu"  => "Basque",
				"ee"  => "Ewe",
				"fo"  => "Faroese",
				"fa"  => "Persian",
				"fj"  => "Fijian",
				"fi"  => "Finnish",
				"fr"  => "French",
				"fy"  => "Western Frisian",
				"ff"  => "Fulah",
				"ka"  => "Georgian",
				"de"  => "German",
				"gd"  => "Gaelic, Scottish Gaelic",
				"ga"  => "Irish",
				"gl"  => "Galician",
				"gv"  => "Manx",
				"el"  => "Greek, Modern (1453-)",
				"gn"  => "Guarani",
				"gu"  => "Gujarati",
				"ht"  => "Haitian; Haitian Creole",
				"ha"  => "Hausa",
				"he"  => "Hebrew",
				"hz"  => "Herero",
				"hi"  => "Hindi",
				"ho"  => "Hiri Motu",
				"hr"  => "Croatian",
				"hu"  => "Hungarian",
				"hy"  => "Armenian",
				"ig"  => "Igbo",
				"is"  => "Icelandic",
				"io"  => "Ido",
				"ii"  => "Sichuan Yi",
				"iu"  => "Inuktitut",
				"ie"  => "Interlingue",
				"ia"  => "Interlingua (IALA)",
				"id"  => "Indonesian",
				"ik"  => "Inupiaq",
				"is"  => "Icelandic",
				"it"  => "Italian",
				"jv"  => "Javanese",
				"ja"  => "Japanese",
				"kl"  => "Kalaallisut, Greenlandic",
				"kn"  => "Kannada",
				"ks"  => "Kashmiri",
				"ka"  => "Georgian",
				"kr"  => "Kanuri",
				"kk"  => "Kazakh",
				"km"  => "Central Khmer",
				"ki"  => "Kikuyu; Gikuyu",
				"rw"  => "Kinyarwanda",
				"ky"  => "Kirghiz; Kyrgyz",
				"kv"  => "Komi",
				"kg"  => "Kongo",
				"ko"  => "Korean",
				"kj"  => "Kuanyama; Kwanyama",
				"ku"  => "Kurdish",
				"lo"  => "Lao",
				"la"  => "Latin",
				"lv"  => "Latvian",
				"li"  => "Limburgan",
				"ln"  => "Lingala",
				"lt"  => "Lithuanian",
				"lb"  => "Luxembourgish,Letzeburgesch",
				"lu"  => "Luba-Katanga",
				"lg"  => "Ganda",
				"mk"  => "Macedonian",
				"mh"  => "Marshallese",
				"ml"  => "Malayalam",
				"mi"  => "Maori",
				"mr"  => "Marathi",
				"ms"  => "Malay",
				"mk"  => "Macedonian",
				"mg"  => "Malagasy",
				"mt"  => "Maltese",
				"mo"  => "Moldavian",
				"mn"  => "Mongolian",
				"mi"  => "Maori",
				"ms"  => "Malay",
				"my"  => "Burmese",
				"na"  => "Nauru",
				"nv"  => "Navajo; Navaho",
				"nr"  => "Ndebele, South",
				"nd"  => "Ndebele, North",
				"ng"  => "Ndonga",
				"ne"  => "Nepali",
				"nl"  => "Dutch; Flemish",
				"nn"  => "Norwegian Nynorsk",
				"nb"  => "Bokm?l, Norwegian",
				"no"  => "Norwegian",
				"ny"  => "Chichewa, Chewa, Nyanja",
				"oc"  => "Occitan, Proven?al",
				"oj"  => "Ojibwa",
				"or"  => "Oriya",
				"om"  => "Oromo",
				"os"  => "Ossetian,Ossetic",
				"pa"  => "Panjabi, Punjabi",
				"fa"  => "Persian",
				"pi"  => "Pali",
				"pl"  => "Polish",
				"pt"  => "Portuguese",
				"ps"  => "Pushto",
				"qu"  => "Quechua",
				"rm"  => "Romansh",
				"ro"  => "Romanian",
				"ro"  => "Romanian",
				"rn"  => "Rundi",
				"ru"  => "Russian",
				"sg"  => "Sango",
				"sa"  => "Sanskrit",
				"sr"  => "Serbian",
				"hr"  => "Croatian",
				"si"  => "Sinhala,Sinhalese",
				"sk"  => "Slovak",
				"sk"  => "Slovak",
				"sl"  => "Slovenian",
				"se"  => "Northern Sami",
				"sm"  => "Samoan",
				"sn"  => "Shona",
				"sd"  => "Sindhi",
				"so"  => "Somali",
				"st"  => "Sotho, Southern",
				"es"  => "Spanish, Castilian",
				"sq"  => "Albanian",
				"sc"  => "Sardinian",
				"sr"  => "Serbian",
				"ss"  => "Swati",
				"su"  => "Sundanese",
				"sw"  => "Swahili",
				"sv"  => "Swedish",
				"ty"  => "Tahitian",
				"ta"  => "Tamil",
				"tt"  => "Tatar",
				"te"  => "Telugu",
				"tg"  => "Tajik",
				"tl"  => "Tagalog",
				"th"  => "Thai",
				"bo"  => "Tibetan",
				"ti"  => "Tigrinya",
				"to"  => "Tonga",
				"tn"  => "Tswana",
				"ts"  => "Tsonga",
				"tk"  => "Turkmen",
				"tr"  => "Turkish",
				"tw"  => "Twi",
				"ug"  => "Uighur, Uyghur",
				"uk"  => "Ukrainian",
				"ur"  => "Urdu",
				"uz"  => "Uzbek",
				"ve"  => "Venda",
				"vi"  => "Vietnamese",
				"vo"  => "Volap?_k",
				"cy"  => "Welsh",
				"wa"  => "Walloon",
				"wo"  => "Wolof",
				"xh"  => "Xhosa",
				"yi"  => "Yiddish",
				"yo"  => "Yoruba",
				"za"  => "Zhuang; Chuang",
				"zh"  => "Chinese",
				"zu"  => "Zulu"
		);	
		
		
	// Function for Language Dropdown 
	
	function language_selector($lang_code = 'en'){
		global $pubML, $pubml_language_array;
		$lang = '';
		
		//echo "<select name='book_lanugauage' id='term_meta_language' class='$class'>";
			foreach($pubml_language_array as $key=>$value){
				$selected = ($lang_code == $key ) ? ' selected = "selected" ' : '' ;
				$lang .="<option $selected value=$key>$value</option>";
			}
			
		//echo "</select>";
		return $lang;
	}
	
	
 function pubml_get_rolename($key=''){
		// PubML Book user Role 

	$pubml_users_role = array(
			'aut'  =>  'Author',
			'abr'  =>  'Abridger',
			'acp'  =>  'Art copyist',
			'act'  =>  'Actor',
			'adi'  =>  'Art director',
			'adp'  =>  'Adapter',
			'aft'  =>  'Author afterword,colophon,etc.',
			'anl'  =>  'Analyst',
			'anm'  =>  'Animator',
			'ann'  =>  'Annotator',
			'ant'  =>  'Bibliographic antecedent',
			'ape'  =>  'Appellee',
			'apl'  =>  'Appellant',
			'app'  =>  'Applicant',
			'aqt'  =>  'Author quotations,abstracts',
			'arc'  =>  'Architect',
			'ard'  =>  'Artistic director',
			'arr'  =>  'Arranger',
			'art'  =>  'Artist',
			'asg'  =>  'Assignee',
			'asn'  =>  'Associated name',
			'ato'  =>  'Autographer',
			'att'  =>  'Attributed name',
			'auc'  =>  'Auctioneer',
			'aud'  =>  'Author of dialog',
			'aui'  =>  'Author of introduction, etc.',
			'aus'  =>  'Screenwriter',
			'bdd'  =>  'Binding designer',
			'bjd'  =>  'Bookjacket designer',
			'bkd'  =>  'Book designer',
			'bkp'  =>  'Book producer',
			'blw'  =>  'Blurb writer',
			'bnd'  =>  'Binder',
			'bpd'  =>  'Bookplate designer',
			'brd'  =>  'Broadcaster',
			'brl'  =>  'Braille embosser',
			'bsl'  =>  'Bookseller',
			'cas'  =>  'Caster',
			'ccp'  =>  'Conceptor',
			'chr'  =>  'Choreographer',
			'-clb'  =>  'Collaborator',
			'cli'  =>  'Client',
			'cll'  =>  'Calligrapher',
			'clr'  =>  'Colorist',
			'clt'  =>  'Collotyper',
			'cmm'  =>  'Commentator',
			'cmp'  =>  'Composer',
			'cmt'  =>  'Compositor',
			'cnd'  =>  'Conductor',
			'cng'  =>  'Cinematographer',
			'cns'  =>  'Censor',
			'coe'  =>  'Contestant-appellee',
			'col'  =>  'Collector',
			'com'  =>  'Compiler',
			'con'  =>  'Conservator',
			'cor'  =>  'Collection registrar',
			'cos'  =>  'Contestant',
			'cot'  =>  'Contestant-appellant',
			'cou'  =>  'Court governed',
			'cov'  =>  'Cover designer',
			'cpc'  =>  'Copyright claimant',
			'cpe'  =>  'Complainant-appellee',
			'cph'  =>  'Copyright holder',
			'cpl'  =>  'Complainant',
			'cpt'  =>  'Complainant-appellant',
			'cre'  =>  'Creator',
			'crp'  =>  'Correspondent',
			'crr'  =>  'Corrector',
			'crt'  =>  'Court reporter',
			'csl'  =>  'Consultant',
			'csp'  =>  'Consultant to a project',
			'cst'  =>  'Costume designer',
			'ctb'  =>  'Contributor',
			'cte'  =>  'Contestee-appellee',
			'ctg'  =>  'Cartographer',
			'ctr'  =>  'Contractor',
			'cts'  =>  'Contestee',
			'ctt'  =>  'Contestee-appellant',
			'cur'  =>  'Curator',
			'cwt'  =>  'Commentator for text',
			'dbp'  =>  'Distribution place',
			'dfd'  =>  'Defendant',
			'dfe'  =>  'Defendant-appellee',
			'dft'  =>  'Defendant-appellant',
			'dgg'  =>  'Degree granting institution',
			'dis'  =>  'Dissertant',
			'dln'  =>  'Delineator',
			'dnc'  =>  'Dancer',
			'dnr'  =>  'Donor',
			'dpc'  =>  'Depicted',
			'dpt'  =>  'Depositor',
			'drm'  =>  'Draftsman',
			'drt'  =>  'Director',
			'dsr'  =>  'Designer',
			'dst'  =>  'Distributor',
			'dtc'  =>  'Data contributor',
			'dte'  =>  'Dedicatee',
			'dtm'  =>  'Data manager',
			'dto'  =>  'Dedicator',
			'dub'  =>  'Dubious author',
			'edc'  =>  'Editor of compilation',
			'edm'  =>  'Editor of moving image work',
			'edt'  =>  'Editor',
			'egr'  =>  'Engraver',
			'elg'  =>  'Electrician',
			'elt'  =>  'Electrotyper',
			'eng'  =>  'Engineer',
			'enj'  =>  'Enacting jurisdiction',
			'etr'  =>  'Etcher',
			'evp'  =>  'Event place',
			'exp'  =>  'Expert',
			'fac'  =>  'Facsimilist',
			'fds'  =>  'Film distributor',
			'fld'  =>  'Field director',
			'flm'  =>  'Film editor',
			'fmd'  =>  'Film director',
			'fmk'  =>  'Filmmaker',
			'fmo'  =>  'Former owner',
			'fmp'  =>  'Film producer',
			'fnd'  =>  'Funder',
			'fpy'  =>  'First party',
			'frg'  =>  'Forger',
			'gis'  =>  'Geographic information specialist',
			'his'  =>  'Host institution',
			'hnr'  =>  'Honoree',
			'hst'  =>  'Host',
			'ill'  =>  'Illustrator',
			'ilu'  =>  'Illuminator',
			'ins'  =>  'Inscriber',
			'itr'  =>  'Instrumentalist',
			'ive'  =>  'Interviewee',
			'ivr'  =>  'Interviewer',
			'inv'  =>  'Inventor',
			'isb'  =>  'Issuing body',
			'jud'  =>  'Judge',
			'jug'  =>  'Jurisdiction governed',
			'lbr'  =>  'Laboratory',
			'lbt'  =>  'Librettist',
			'ldr'  =>  'Laboratory director',
			'led'  =>  'Lead',
			'lee'  =>  'Libelee-appellee',
			'lel'  =>  'Libelee',
			'len'  =>  'Lender',
			'let'  =>  'Libelee-appellant',
			'lgd'  =>  'Lighting designer',
			'lie'  =>  'Libelant-appellee',
			'lil'  =>  'Libelant',
			'lit'  =>  'Libelant-appellant',
			'lsa'  =>  'Landscape architect',
			'lse'  =>  'Licensee',
			'lso'  =>  'Licensor',
			'ltg'  =>  'Lithographer',
			'lyr'  =>  'Lyricist',
			'mcp'  =>  'Music copyist',
			'mdc'  =>  'Metadata contact',
			'mfp'  =>  'Manufacture place',
			'mfr'  =>  'Manufacturer',
			'mod'  =>  'Moderator',
			'mon'  =>  'Monitor',
			'mrb'  =>  'Marbler',
			'mrk'  =>  'Markup editor',
			'msd'  =>  'Musical director',
			'mte'  =>  'Metal-engraver',
			'mus'  =>  'Musician',
			'nrt'  =>  'Narrator',
			'opn'  =>  'Opponent',
			'org'  =>  'Originator',
			'orm'  =>  'Organizer of meeting',
			'osp'  =>  'Onscreen presenter',
			'oth'  =>  'Other',
			'own'  =>  'Owner',
			'pan'  =>  'Panelist',
			'pat'  =>  'Patron',
			'pbd'  =>  'Publishing director',
			'pbl'  =>  'Publisher',
			'pdr'  =>  'Project director',
			'pfr'  =>  'Proofreader',
			'pht'  =>  'Photographer',
			'plt'  =>  'Platemaker',
			'pma'  =>  'Permitting agency',
			'pmn'  =>  'Production manager',
			'pop'  =>  'Printer of plates',
			'ppm'  =>  'Papermaker',
			'ppt'  =>  'Puppeteer',
			'pra'  =>  'Praeses',
			'prc'  =>  'Process contact',
			'prd'  =>  'Production personnel',
			'pre'  =>  'Presenter',
			'prf'  =>  'Performer',
			'prg'  =>  'Programmer',
			'prm'  =>  'Printmaker',
			'prn'  =>  'Production company',
			'pro'  =>  'Producer',
			'prp'  =>  'Production place',
			'prs'  =>  'Production designer',
			'prt'  =>  'Printer',
			'prv'  =>  'Provider',
			'pta'  =>  'Patent applicant',
			'pte'  =>  'Plaintiff-appellee',
			'ptf'  =>  'Plaintiff',
			'pth'  =>  'Patent holder',
			'ptt'  =>  'Plaintiff-appellant',
			'pup'  =>  'Publication place',
			'rbr'  =>  'Rubricator',
			'rce'  =>  'Recording engineer',
			'rcd'  =>  'Recordist',
			'rcp'  =>  'Addressee',
			'rdd'  =>  'Radio director',
			'red'  =>  'Redaktor',
			'ren'  =>  'Renderer',
			'res'  =>  'Researcher',
			'rev'  =>  'Reviewer',
			'rpc'  =>  'Radio producer',
			'rps'  =>  'Repository',
			'rpt'  =>  'Reporter',
			'rpy'  =>  'Responsible party',
			'rse'  =>  'Respondent-appellee',
			'rsg'  =>  'Restager',
			'rsp'  =>  'Respondent',
			'rsr'  =>  'Restorationist',
			'rst'  =>  'Respondent-appellant',
			'rth'  =>  'Research team head',
			'rtm'  =>  'Research team member',
			'sad'  =>  'Scientific advisor',
			'sce'  =>  'Scenarist',
			'scl'  =>  'Sculptor',
			'scr'  =>  'Scribe',
			'sds'  =>  'Sound designer',
			'sec'  =>  'Secretary',
			'sgd'  =>  'Stage director',
			'sgn'  =>  'Signer',
			'sht'  =>  'Supporting host',
			'sll'  =>  'Seller',
			'sng'  =>  'Singer',
			'spk'  =>  'Speaker',
			'spn'  =>  'Sponsor',
			'spy'  =>  'Second party',
			'std'  =>  'Set designer',
			'stg'  =>  'Setting',
			'stl'  =>  'Storyteller',
			'stm'  =>  'Stage manager',
			'stn'  =>  'Standards body',
			'str'  =>  'Stereotyper',
			'srv'  =>  'Surveyor',
			'tcd'  =>  'Technical director',
			'tch'  =>  'Teacher',
			'ths'  =>  'Thesis advisor',
			'tld'  =>  'Television director',
			'tlp'  =>  'Television producer',
			'trc'  =>  'Transcriber',
			'trl'  =>  'Translator',
			'tyd'  =>  'Type designer',
			'tyg'  =>  'Typographer',
			'uvp'  =>  'University place',
			'vdg'  =>  'Videographer',
			'wac'  =>  'Writer of added commentary',
			'wal'  =>  'Writer of added lyrics',
			'wam'  =>  'Writer of accompanying material',
			'wat'  =>  'Writer of added text',
			'wdc'  =>  'Woodcutter',
			'wde'  =>  'Wood engraver',
			'wit'  =>  'Witness'
		);
		if ($key !=  '') {
			return $pubml_users_role[$key];	
		}else {
			return $pubml_users_role;
		}
}
	// Function for PubML User's Role Dropdown 
	
	function pubml_role_selector($default_role='aut'){
		global $pubML;
		$pubml_users_role = pubml_get_rolename();
		$user_role = '';
			foreach($pubml_users_role as $key=>$value){
				$selected = ($default_role == $key ) ? ' selected = "selected" ' : '' ;
				$user_role .="<option $selected value=$key>$value</option>";
			}
		return $user_role;
	}

	/* Function to generate the PubML Zip file for each book separately while Exporting  */
	function pubml_generate_book($bookid = '', $showBadge = false) {
		global $pubml, $wpdb;	
		$result = array();	
		//$book_id = $_POST['bookId'];	
		$plugin_name = PUBML_EBOOK_PUBLISHER;								// $plugin_name = 'PubML eBook Publisher Plugin';
		$site_url = urlencode(trim(get_option('siteurl')));		 					// $site_url  = urlencode('http://bma.in/pubml/');
		$license_key = trim( get_option('pubml_ebook_license_key'));		// $license_key  = 'ddsadf545sf4saf54rrearrrreff555ee';
		$plugin_l_sts = array();

		// Create the client instance(object)
		$client = new nusoap_client(RENDER_URL, true);  		// Call the renderer Server.
		$client->setCredentials("pubml", "123456", "basic");	// Use basic authentication method

		// Check for an error
		$err = $client->getError();
		if ($err) {
			// Return the error
			$result['bookId'] = $book_id;
				$result['status'] = 'false';
				$result['msg'] = 'Constructor error';
				$result['error'] =  $err ;
			echo json_encode($result);	
			exit(0);						
		}	

		$book_id =($_POST['bookId']) ? $_POST['bookId']  : $bookid ;
		$book = get_term_by('id', $book_id, 'book');
		@$showBadge =($_POST['showBadge']) ? $_POST['showBadge']  : $showBadge ;	
		@$showBadge =($showBadge &&($showBadge=='true')) ? true  : false ;
		
		if(!$book){		
			$result['bookId'] = $book_id;
			$result['status'] = 'false';
			$result['msg'] = 'No Book found';
			$result['error'] =  'not_found' ;
			echo json_encode($result);
			exit();		
		}				
		
		if(!$removed = clear_old_zips($book->slug)){
				$result['bookId'] = $book_id;
				$result['status'] = 'false';
				$result['msg'] = 'Cannot remove old zip files';
				$result['error'] =  'not_remooved'; 
			echo json_encode($result);	
			exit(0);
		}
		
	try {	
			
		$chapters_array = array();
		$chapters_query = get_posts(array( 
			'post_type' => 'pubml_books',
			'showposts' => -1,
			'meta_key' => 'sorting_status',
			'orderby' => 'meta_value_num',
			'tax_query' => array(
				array(
					'taxonomy' => 'book',
					'terms' => $book_id,
					'field' => 'term_id',
				)
			),  
			// 'orderby' => 'title',
			'order' => 'ASC' )
		);	
		
		if ( count( $chapters_query) ) {			
			$f = $book->slug.'-'.date('m-d-Y_hia').'.zip';  //# create zip file
			//$f = $book->slug.'.zip';
			$upload_dir = wp_upload_dir();
			$dir = $upload_dir['path'];
			$filename = $dir.'/'.$f;		

			if ($upload_dir['error']) { 
					$result['bookId'] = $book_id;
					$result['status'] = 'false';
					$result['msg'] = $upload_dir['error'];
					$result['error'] =  'not_uploads'; 
				echo json_encode($result);
				exit(0);
			}
			if (! is_dir($dir)) {
					$result['bookId'] = $book_id;
					$result['status'] = 'false';
					$result['msg'] = 'Upload directory: ' . $dir .'ERROR: Directory does not exist.';
					$result['error'] =  'error'; 
				echo json_encode($result);
				exit(0);				
			}
			if (! is_writable($dir)) {
					$result['bookId'] = $book_id;
					$result['status'] = 'false';
					$result['msg'] = 'Upload directory: ' . $dir .'ERROR: Directory is not writable';
					$result['error'] =  'error';
				echo json_encode($result);
				exit(0);				   
			}

			$url = $upload_dir['url'] . '/'. $f;
			$zip = new ZipArchive;
			$res = $zip->open($filename, ZipArchive::CREATE) or die('Could not create file.');
			if ($res == TRUE) {
				$zip->addEmptyDir($book->slug.'/data');
				$zip->addEmptyDir($book->slug.'/footnotes');
				$zip->addEmptyDir($book->slug.'/footnotes/images');
				$zip->addEmptyDir($book->slug.'/img');
				$zip->addEmptyDir($book->slug.'/scripts');
				$zip->addEmptyDir($book->slug.'/sections');
				$src_image = PUBML_BASE_DIR.'/default/images';
				$dst_image = $book->slug.'/images';
				if(!$copied = recurse_copy($zip, $src_image, $dst_image)){
						$result['bookId'] = $book_id;
						$result['status'] = 'false';
						$result['msg'] = 'Cannot copy the files';
						$result['error'] =  'cannot_copy';
					echo json_encode($result);	
					exit(0);
				}
											
				// Copy default files, CSS and JS to the Archive
				$zip->addFile(PUBML_BASE_DIR.'/default/index.html', $book->slug.'/index.html');
				$zip->addFile(PUBML_BASE_DIR.'/default/license.txt', $book->slug.'/license.txt');
				$zip->addFile(PUBML_BASE_DIR.'/default/instructions.txt', $book->slug.'/instructions.txt');
				$zip->addFile(PUBML_BASE_DIR.'/default/upgrade.html', $book->slug.'/upgrade.html');
				$zip->addFile(PUBML_BASE_DIR.'/default/css/pubml_book_format.less', $book->slug.'/css/pubml_book_format.less');
				$zip->addFile(PUBML_BASE_DIR.'/default/css/pubml_dropcaps.less', $book->slug.'/css/pubml_dropcaps.less');
				$zip->addFile(PUBML_BASE_DIR.'/default/css/pubml_mediapop.css', $book->slug.'/css/pubml_mediapop.css');
				$zip->addFile(PUBML_BASE_DIR.'/default/css/index.html', $book->slug.'/css/index.html');
				$zip->addFile(PUBML_BASE_DIR.'/default/scripts/pubml_mediapop.js', $book->slug.'/scripts/pubml_mediapop.js');
				$zip->addFile(PUBML_BASE_DIR.'/default/scripts/jquery.slimscroll.min.js', $book->slug.'/scripts/jquery.slimscroll.min.js');
				$zip->addFile(PUBML_BASE_DIR.'/default/scripts/jquery.tmpl.min.js', $book->slug.'/scripts/jquery.tmpl.min.js');
				$zip->addFile(PUBML_BASE_DIR.'/default/scripts/jquery.min.js', $book->slug.'/scripts/jquery.min.js');
				$zip->addFile(PUBML_BASE_DIR.'/default/scripts/jquery-1.9.1.js', $book->slug.'/scripts/jquery-1.9.1.js');
				$zip->addFile(PUBML_BASE_DIR.'/default/scripts/less-1.4.1.min.js', $book->slug.'/scripts/less-1.4.1.min.js');
				$zip->addFile(PUBML_BASE_DIR.'/default/scripts/pubML.js', $book->slug.'/scripts/pubML.js');
				$zip->addFile(PUBML_BASE_DIR.'/default/scripts/pubml_settings.js', $book->slug.'/scripts/pubml_settings.js');
				
				// Blank index file has been added for goole indexing
				$zip->addFile(PUBML_BASE_DIR.'/default/css/index.html', $book->slug.'/img/index.html');
				$zip->addFile(PUBML_BASE_DIR.'/default/css/index.html', $book->slug.'/data/index.html');
				$zip->addFile(PUBML_BASE_DIR.'/default/css/index.html', $book->slug.'/data/images/index.html');
				$zip->addFile(PUBML_BASE_DIR.'/default/css/index.html', $book->slug.'/footnotes/index.html');
				$zip->addFile(PUBML_BASE_DIR.'/default/css/index.html', $book->slug.'/footnotes/images/index.html');
				$zip->addFile(PUBML_BASE_DIR.'/default/css/index.html', $book->slug.'/sections/index.html');
				$zip->addFile(PUBML_BASE_DIR.'/default/css/index.html', $book->slug.'/sections/images/index.html');
				
				pubml_navigation_tabs($book_id, $zip);  // Add Tabs in the PubML eBook
				
				$medialist_array = array();
				$customCSS = "/*-----Custom CSS Generated -----*/\n";
				
				 if(!$copiedCSS = pubml_custom_import_css($zip, $book_id)){									
						$result['bookId'] = $book_id;
						$result['status'] = 'false';
						$result['msg'] = 'Cannot generate the Custom Style and CSS';
						$result['error'] =  'error';
					echo json_encode($result);	
					exit(0);
				}else{
					$customCSS .= $copiedCSS;
					$style_editor = pubml_style_editor_css($book_id);
					$custom_css =  $book->slug."/css/pubml_custom.less";								
					$zip->addFromString($custom_css, $customCSS.$style_editor);	
				}
			
				
				$extension = ".html";
				$story = '';
				//$html_story = $story . "\n" . $row->post_content;
					$html_story = $story . "test content" ;				
				
				    $html_head = "<article>\n";                    
                    $html_tail = "\n</article>\n";
                    $story = nl2br($html_story);
                    $story = $html_head . $story . $html_tail;
															
					// Generate HTML Files for all chapters  Start 
					if(!empty($chapters_query)) {
					
						$textStyles = array();
						$txtst_query = "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$book_id} AND {$wpdb->prefix}book_style.type='all-data'";								
						$txtstyles  = $wpdb->get_row($txtst_query);
						if(count($txtstyles)){
							$textStyles =  unserialize($txtstyles->style_data);			
						}else{
							$textStyles =  PubML_default_style_data();
						}
						$head_type = $textStyles['running_head']['head-content'];
						$toc_array = array();	
						$book_metadata = get_option( "taxonomy_$book_id");
						
						$toc_array[] = array(
									"url" 	=> "BookCover.xhtml",
									"title" => $book->name." (Cover)",
									"heading" => "BookCover",
									"type"  => "cover",
									"css_class" => "levelOne"	
									);
						$book_cover_image = ($book_metadata['cover_meta']) ? stripslashes($book_metadata['cover_meta']) : PUBML_BASE_URL."/images/placeholder.png";
						
						$image_name = basename($book_cover_image);	
						$cover_image_dest = $book->slug.'/sections/images/';	
						$cpy = pubml_copy_single_image($zip, $book_cover_image, $cover_image_dest);
						
						$cover_story = "<article>\n <img src='sections/images/$image_name' alt='$book->name' class='coverImage' /> \n</article>\n ";						
						$story = iconv("UTF-8", "ascii//TRANSLIT", $cover_story);
						$zip_name = $book->slug."/sections/BookCover.xhtml";								
						$zip->addFromString($zip_name, $story);								
								
						$updated_post_content ='';	
						
						// Call the renderer function to retuen the TOC Data to bind into the books
						$plugin_license_status = $client->call('getPluginStatus', array ('license'=> $license_key, 'bookid'=> $book_id, 'item_name'=> $plugin_name, 'site_url'=> $site_url));
										
						// Check for a fault
						if ($client->fault) {							
							$result['bookId'] = $book_id;
							$result['msg'] = '<p><b>Fault : There is Fault in the data communication. </b></p>';	// Return the fault
							$result['error'] =  $plugin_license_status;
							
							$created_book_path = $upload_dir['basedir'].'/'.$book->slug.'/index.html';
							if (file_exists($created_book_path)) {
								$result['preview'] = $book->slug.'/index.html';
								$result['status'] = 'true';	
							} else {
								$result['status'] = 'false';
								$result['error'] =  $err ;										
							}							
							echo json_encode($result);	
							exit(0);
						}else {
							// Check for errors
							$err = $client->getError();
							if ($err) {									
								$result['bookId'] = $book_id;
								$result['msg'] = 'Server Error :'.$err;  // Return the error
										
								$created_book_path = $upload_dir['basedir'].'/'.$book->slug.'/index.html';
									if (file_exists($created_book_path)) {
										$result['preview'] = $book->slug.'/index.html';
										$result['status'] = 'true';	
									} else {
										$result['status'] = 'false';
										$result['error'] =  $err ;										
									}	
								echo json_encode($result);	
								exit(0);
							}else{								
								$plugin_l_sts = json_decode($plugin_license_status, true);
								if(($plugin_l_sts['status']=='false')&&($plugin_l_sts['error']=='expired')){									
									
									$result['bookId'] = $book_id;
									$result['msg'] = 'Data Error : '.$plugin_l_sts['message'];	// Return TOC service message
									
									$created_book_path = $upload_dir['basedir'].'/'.$book->slug.'/index.html';
									if (file_exists($created_book_path)) {
										$result['preview'] = $book->slug.'/index.html';
										$result['status'] = 'true';	
									} else {									
										$result['status'] = 'false';										
										$result['error'] =  $plugin_l_sts['error'] ;
									}	
									echo json_encode($result);											
									exit(0);
								}								
							}
						}
						
						
						if((($plugin_l_sts['status']=='false')&&($plugin_l_sts['error']=='empty_license_key'))||(($plugin_l_sts['status']=='false')&&($plugin_l_sts['error']=='inactive'))){
							$chapters_query = pubml_unregistered_chapters_preview();
						}						
			
						foreach($chapters_query as $chapter){
							$custom_section_image = get_post_meta($chapter->ID,'custom_section_image',true);
							switch ($head_type) {
								case 'book-title':											
										$chapter_title = $book->name;
										break;
								case 'author':
										$book_meta = get_option( "taxonomy_$book_id");
										$book_author = $book_meta['contributor1last']." ".$book_meta['contributor1first']." ".$book_meta['contributor1middle'];
										$chapter_title = $book_author;
										break;
								case 'title':
										$chapter_title = $chapter->post_title;
										break;
								case 'custom':
										$chapter_title = $textStyles['running_head']['custom-val-head'];
										break;
								default:	
										$chapter_title = $chapter->post_title;
							}		

							$toc_type = ($custom_section_image) ? "cover"  : "columntext" ;	
							$chapter_order = get_post_meta($chapter->ID, 'toc_parent',true);
							if(isset($chapter_order) && !empty($chapter_order)){
								$level =  'levelTwo';
							}
							else{
								$level =  'levelOne';
							}
							$toc_array[] = array(
									"url" 	=> $chapter->post_name.".html",
									"title" => $chapter->post_title,
									"heading" => strip_tags($chapter_title),
									"type"  => $toc_type,
									"css_class" => $level							
								);
							$story = '';						
							$html_head = "<article>\n";                    
							$html_tail = "\n</article>\n";
							//$html_story = $story . $chapter->post_content ;	
							$updated_post_content = pubml_chapter_toc_images($zip,$book_id,$book->slug,$chapter->post_content);
							// $html_story = $story . do_shortcode(wpautop($chapter->post_content)) ;	
							$html_story = $story . do_shortcode($updated_post_content) ;	
							if($custom_section_image){
								$image_name = basename($custom_section_image);
								
								$story = "<img src='sections/images/$image_name' alt='$chapter->post_title' class='coverImage' />";
								$sec_image_dest = $book->slug.'/sections/images/';	
							
								if(!$copied = pubml_copy_single_image($zip, $custom_section_image, $sec_image_dest)){									
										$result['bookId'] = $book_id;
										$result['status'] = 'false';
										$result['msg'] = 'Cannot copy the image from live url';
										$result['error'] =  'not_copy';
									echo json_encode($result);	
									exit(0);
								}								
							} else {
								//$story = nl2br($html_story);
								$story = $html_story;
							}
						
							$story = $html_head . $story . $html_tail;							
							//$story = iconv("UTF-8", "ascii//TRANSLIT", $story);
							$zip_name = $book->slug."/sections/" . $chapter->post_name . $extension;								
							$zip->addFromString($zip_name, $story);		
							$story = '';		
						}	
						unset($chapters_query);	
						if((($plugin_l_sts['status']=='false')&&($plugin_l_sts['error']=='empty_license_key'))||(($plugin_l_sts['status']=='false')&&($plugin_l_sts['error']=='inactive'))){
							$zip->addFile(PUBML_BASE_DIR.'/settings/toc.json', $book->slug.'/data/toc.json'); // TOC Path Here	
							$zip->addFile(PUBML_BASE_DIR.'/settings/blank_bedge.png', $book->slug.'/data/images/pubml_license_badge.png'); // TOC Path Here	
							
						}else{
							// Call the renderer function to retuen the TOC Data to bind into the books
							$resultSet = $client->call('getTocData', array ('license'=> $license_key, 'bookid'=> $book_id, 'item_name'=> $plugin_name, 'site_url'=> $site_url, 'show_badge'=> $showBadge, 'content'=> $toc_array));
											
							// Check for a fault
							if ($client->fault) {
								// Return the fault
								$result['bookId'] = $book_id;
								$result['status'] = 'false';
								$result['msg'] = '<p><b>Fault : There is Fault in the data communication. </b></p>';
								$result['error'] =  $resultSet;
								echo json_encode($result);	
								exit(0);
							}else {
								// Check for errors
								$err = $client->getError();
								if ($err) {	
									$result['bookId'] = $book_id;
									$result['msg'] = 'Server Error :'.$err;		// Return the error
									
									$created_book_path = $upload_dir['basedir'].'/'.$book->slug.'/index.html';
									if (file_exists($created_book_path)) {
										$result['preview'] = $book->slug.'/index.html';
										$result['status'] = 'true';	
									} else {
										$result['status'] = 'false';
										$result['error'] =  $err ;										
									}	
									echo json_encode($result);	
									exit(0);
								}else{								
									// echo '<h2>Result</h2><pre>';	// print_r($resultSet);	// echo '</pre>'; 	// Display the result
									$toc_status = json_decode($resultSet, true);
									if(($toc_status['status']=='false')&&($toc_status['error']=='expired')){
										$result['bookId'] = $book_id;
										$result['msg'] = 'Data Error : '.$toc_status['message'];	// Return TOC service message
										
										$created_book_path = $upload_dir['basedir'].'/'.$book->slug.'/index.html';
										if (file_exists($created_book_path)) {
											$result['preview'] = $book->slug.'/index.html';
											$result['status'] = 'true';	
										} else {
											$result['status'] = 'false';										
											$result['error'] =  $toc_status['error'] ;
										}	
										echo json_encode($result);											
										exit(0);
									}else if($toc_status['status']=='false'){
										// Return TOC service message
										$result['bookId'] = $book_id;
										$result['status'] = 'false';
										$result['msg'] = 'Data Error : '.$toc_status['message']  ;
										$result['error'] =  $toc_status['error'] ;
										echo json_encode($result);	
										exit(0);								
									}
									$tocdata = iconv("UTF-8", "ascii//TRANSLIT", $resultSet);
									$zip->addFromString($book->slug . $toc_status['file'], $tocdata);								
									$badge_path = file_get_contents($toc_status['badge_path']);				
									$zip->addFromString($book->slug . '/data/images/pubml_license_badge.png', $badge_path);	
								}
							}						
						}	
						
					} // Generate HTML Files for all chapters  End 
					
					
				if((($plugin_l_sts['status']=='false')&&($plugin_l_sts['error']=='empty_license_key'))||(($plugin_l_sts['status']=='false')&&($plugin_l_sts['error']=='inactive'))){
					$zip->addFile(PUBML_BASE_DIR.'/settings/pubml_mediaList.js', $book->slug.'/data/pubml_mediaList.js'); // Media List Here
					$result['book_type'] = 'unregistered_preview';
				}else{					
					
					// Generate HTML Files for all Footnotes Start 
						$footnotes_query = get_posts(array( 
							'post_type' => 'pubml_footnotes',
							'showposts' => -1,
							'meta_query' => array(
								array(
									'key' => 'book',
									'value' => $book_id,
								)
							),
							'orderby' => 'title',
							'order' => 'ASC' )
						);	
					
						if(!empty($footnotes_query)) {
							$foot_array = array(); 
							foreach($footnotes_query as $note){
								$story = '';
								$custom_footnote_image = get_post_meta($note->ID,'custom_footnote_image',true);
								
								if($custom_footnote_image){
									$image_name = basename($custom_footnote_image);
									
									$story .= "<illustration><img src='footnotes/images/$image_name' width='260' height='180' alt='$note->post_title' /></illustration>";
									$image_dest = $book->slug.'/footnotes/images/';	
									
									if(!$copied = pubml_copy_single_image($zip, $custom_footnote_image, $image_dest)){									
											$result['bookId'] = $book_id;
											$result['status'] = 'false';
											$result['msg'] = 'Cannot copy the image from live url';
											$result['error'] =  'not_copy';
										echo json_encode($result);	
										exit(0);
									}
									
								}else{
									$story .= "<illustration><img src='images/default_note_bg.jpg' width='260' height='180' alt='$note->post_title' /></illustration>";
								}
												
								$html_story = $story . "<description>" . wpautop($note->post_content)."</description>";
								$html_head = "<footnote_card>\n";                    
								$html_tail = "\n</footnote_card>\n";							
								$story = nl2br($html_story);
								$story = $html_head . $story . $html_tail;
								
								//$story = iconv("UTF-8", "ascii//TRANSLIT", $story);
								$zip_name =  $book->slug."/footnotes/" . $note->post_name . $extension;								
								$zip->addFromString($zip_name, $story);		
								$story = '';
								$footnt = sanitize_title($note->post_title);
								$foot_array[$footnt] = "$note->post_name.html";
							}

							$medialist_array['footnotes'] = $foot_array;

						} //Generate HTML Files for all Footnotes End
						
						unset($footnotes_query);
						wp_reset_query();  
						wp_reset_postdata();
						
						// Generate medialistArray Contents and title for the js and overlay start. 
						$mygroups = $wpdb->get_results( "SELECT * FROM {$wpdb->prefix}media_group WHERE {$wpdb->prefix}media_group.book_id = {$book_id} ORDER BY {$wpdb->prefix}media_group.group_slug ASC ", OBJECT);
						
						if ($mygroups) { 
							$count=1;
							$title_arr = array();
							$media_array = array('map'=>array(),'youtube'=>array(),'flickr'=>array(),'wordpress'=>array(),'default'=>array());
							foreach ( $mygroups as $group ) {
								
								$related_groups = $wpdb->get_results( "SELECT *	FROM {$wpdb->prefix}media_group_association WHERE {$wpdb->prefix}media_group_association.book_id ={$book_id} AND  	{$wpdb->prefix}media_group_association.associate_groups ={$group->group_id} ", OBJECT);	
				
								if (count($related_groups)) { 
								
									foreach ( $related_groups as $media ) {
										$media_source = $wpdb->get_row("SELECT *  FROM {$wpdb->prefix}book_media WHERE media_id = {$media->media_id} and book_id = {$book_id}", ARRAY_A);
										
										$media_type = $media_source['media_type'];
										$media_url = $media_source['media_url'];
										if(!array_key_exists($media_type, $media_array)){
											$media_type = 'wordpress';
										}
																				
										if(array_key_exists($group->group_slug,$media_array[$media_type])){
											array_push($media_array[$media_type][$group->group_slug], $media_url); 
										}else{
											$media_array[$media_type][$group->group_slug] = array($media_url);
										}
									}	                                 
								}													
								if(!empty($group->group_slug) && !empty($group->group_title))
									$title_arr[ $group->group_slug ] =	urlencode($group->group_title);
							}
							
							$medialist_array['title'] = $title_arr;
							$medialist_array = array_merge($medialist_array,$media_array);

							// echo "<pre>  ";	// print_r (serialize($medialist_array)); // print_r ($medialist_array); // echo "</pre>";	// exit;							
						}	
						unset($mygroups);
						wp_reset_query();  
						wp_reset_postdata();

						$mediadata = serialize($medialist_array);
						
						$mediadata = ( isset($mediadata)) ? $mediadata :  '' ;
						
						// Call soap service for renderer function to retuen the Medialist Data to bind into the associated books
						$resultMediaList = $client->call('getMediaListData', array ('license'=> $license_key, 'bookid'=> $book_id, 'item_name'=> $plugin_name, 'site_url'=> $site_url, 'mediadata'=> $mediadata));
											
						// Check for a fault
						if ($client->fault) {
							// Return the fault
							$result['bookId'] = $book_id;
								$result['status'] = 'false';
								$result['msg'] = '<p><b>Fault : There is Fault in the data communication. </b></p>';
								$result['error'] =  $resultMediaList;
							echo json_encode($result);	
							exit(0);
						}else {
							// Check for errors
							$err = $client->getError();
							if ($err) {
								// Return the error
								$result['bookId'] = $book_id;
									$result['status'] = 'false';
									$result['msg'] = 'Server Error :';
									$result['error'] =  $err ;
								echo json_encode($result);	
								exit(0);
							}else{
								$med_status = json_decode($resultMediaList, true);
								if($med_status['status']=='false'){
									// Return TOC service message
									$result['bookId'] = $book_id;
										$result['status'] = 'false';
										$result['msg'] = 'Data Error : '.$med_status['message']  ;
										$result['error'] =  $med_status['error'] ;
									echo json_encode($result);	
									exit(0);
								}
								// Generate medialistArray Contents and title for the pubml_mediaList.js file.
								$zip_name =  $book->slug."/data/pubml_mediaList.js";								
								$zip->addFromString($zip_name, $med_status['mediadata']);		
							}
						}
						// Ends of Call the renderer function to retuen the Medialist Data to bind into the associated books						
					}
					
					$story = iconv("UTF-8", "ascii//TRANSLIT", $story);										
					$zip_name =  $book->slug."/images/index". $extension;
					$zip->addFromString($zip_name, $story);					
					$zip_name =  $book->slug."/scripts/index". $extension;
					$zip->addFromString($zip_name, $story);
									
					$zip->close();
					wp_reset_query(); 
					wp_reset_postdata();					
						
						$result['bookId'] = $book_id;
						$result['status'] = 'true';
						$result['bookpath'] = $url;
						$result['msg'] = 'Thanks for supporting PubML. Render successful!';
						if($bookid){return $url;}	

					echo json_encode($result);
					exit(0);
					
				} else {				
					$result['bookId'] = $book_id;
					$result['status'] = 'false';
					$result['msg'] = 'Could not create zip file';
					$result['error'] =  'not_zip';
				echo json_encode($result);
				exit(0);
			}	

		} else {  
				$result['bookId'] = $book_id;
				$result['status'] = 'false';
				$result['msg'] = 'No Pages found';
				$result['error'] =  'not_found';
			echo json_encode($result);
			exit(0);
		}
		wp_reset_query();  	// Restore original Post Data		
		wp_reset_postdata();
		echo json_encode($result);
		exit();	
	} catch (Exception $e) {
		$result['status'] = 'false';
		$result['msg'] = 'Something went wrong.';
		$result['error'] =  'exception';
		echo json_encode($result);
		exit(0);
    }		
}

	add_action('wp_ajax_pubml_generate_book', 'pubml_generate_book');
	add_action('wp_ajax_nopriv_pubml_generate_book', 'pubml_generate_book');	
	

	// recursive function to copy the content in the Archive file.
	
	// $src = PUBML_BASE_DIR.'/default/images';
	// $dst = $book->slug.'/images/';
	
	function recurse_copy($zipObj, $src, $dst) {
		$copied = false ;
		$dir = opendir($src); 
		$zipObj->addEmptyDir($dst);
		while(false !== ( $file = readdir($dir)) ) { 
			if (( $file != '.' ) && ( $file != '..' )) { 
				if ( is_dir($src . '/' . $file) ) { 
					recurse_copy($zipObj, $src . '/' . $file, $dst . '/' . $file); 
				} 
				else { 
					$copied = $zipObj->addFile($src . '/' . $file, $dst . '/' . $file);								
				} 
			} 
		} 
		closedir($dir); 
		return $copied ;
	}
	
	// Function to remove the old zip files from the server Upload directory
	function clear_old_zips($book ) {
		global $wpdb;
		$removed = FALSE ; 
		
			$files = $book.'*.zip';		
			$upload_dir = wp_upload_dir();
			$dir = $upload_dir['path'];
			$filename = $dir.'/'.$files;		
			$out = array_map('unlink', glob("$filename")); 
			
		return true;
	}	
	
	// Function to copy a image to a secfic directory from server
	// $live_url = 'http://pubml.com/pubml-content/uploads/2013/11/amphibicon.jpeg';
	// $dest = $book->slug.'/footnotes/images/';	
	
	function copy_single_image($zipObj, $live_url, $dest) {
		global $wpdb;
		$copied = FALSE ; 
		$image_path = explode('/', $live_url);
		$image_name = $image_path[count($image_path)-1];
		
		$wp_upload_dir = wp_upload_dir();
		$upload_dir = $wp_upload_dir['basedir'];
								
		$result = preg_match( '@(uploads)(.*)@i', $live_url , $matches );		
		$image_base_dir = $upload_dir. $matches[2];
		
		//exit($image_base_dir."  oo  ".$dest.$image_name);			
		return $zipObj->addFile($image_base_dir, $dest.$image_name);		
	}
	
	// Function to copy a image to a secfic directory from server
	// $live_url = 'http://pubml.com/pubml-content/uploads/2013/11/amphibicon.jpeg';
	// $dest = $book->slug.'/footnotes/images/';	
	
	function pubml_copy_single_image($zipObj, $live_url, $dest, $img_name = '') {
		global $wpdb;
		$copied = FALSE ; 
		
		$image_name = ($img_name) ? $img_name : (basename($live_url)); 
		$image_abs_path = str_replace(WP_CONTENT_URL, WP_CONTENT_DIR, $live_url, $count);
		if (@file_exists($image_abs_path)) {
			return $zipObj->addFile($image_abs_path, $dest.$image_name);	
		}
		return true;
	}
	
	// Function to call PubML Fonts Dropdown 
	
	function pubml_fonts_dropdown($name = 'default'){		
		global $pubML, $wpdb;
		$font_html = '';
		$dropdown_id = 'PubML_fonts_'.$name;
		
		// $_pubml_fonts = get_option( 'pubml_fonts' );
		
		$pubml_fonts = get_option( 'pubml_fonts' );
		if(empty( $pubml_fonts )){
			$_pubml_fonts = pubml_styles_default_fonts();
		}
		else{
			$_pubml_fonts = $pubml_fonts ;
		}
				
		//echo "<pre>".$class_name; print_r($_pubml_fonts); echo "</pre>";	
			$font_html .= "<select name='$name' class='text-font-menu' id='$dropdown_id'>" ;
			$font_html .= "<option value='Readers Choice'>Reader's Choice</option>" ;
				if( !empty( $_pubml_fonts )){
					foreach($_pubml_fonts as $k => $v){
					
						$font_family_pattern = '/font-family: \'(.*)\',/i';
						$result = preg_match( $font_family_pattern, stripslashes(htmlentities($v['family'])) , $font_matches );	
						$font_name = ($v['font_type']) ? stripslashes(htmlentities($v['fallback'])) : $font_matches[1];
						$font_family = ($v['font_type']) ? 'font-family:'.stripslashes(htmlentities($v['fallback'])).';' : stripslashes(htmlentities($v['family'])) ;			
							
						$ff = '';	
						if ( !$v['font_type'] ){									
							preg_match("/(font-family:)(.*)\;/", stripslashes(htmlentities($v['family'])), $font_family);
							$ff = $font_family[2].", ".stripslashes(htmlentities($v['fallback']));
						}else{
							$ff = $font_name;
						}	
						$font_html .= '<option value="'.$ff.'">'.$font_name.'</option>';
					}
				}
			$font_html .= '</select>';		
		return $font_html;
	}

// ========================= tinyMCE =================================
/* route tinyMCE to our pubml_stylesheet */
function pubml_mce_css($default_style) {
    /* replace the default editor-style.css with custom CSS generated on the fly by the php version */
 
    $mce_css_file = trailingslashit(PUBML_BASE_DIR) . 'css/pubml_tinymce-custom-style.css';
    $mce_css_dir  = trailingslashit(PUBML_BASE_URL) . 'css/pubml_tinymce-custom-style.css';
    if (!@file_exists($mce_css_file)) {	// see if it is there
        return $default_style;
    }
    /* if we have a custom style file, return that instead of the default */
    // Build the overrides
    $put = '?mce=1&book='.$_GET['book'];	// cheap way to start with ?
    return $mce_css_dir . $put;
}

/*
	Deafult styles drop down
*/
	function pubml_styles_default_values($key=''){
			$pubml_default_styles = array(
			'1' => array (
					'style_name' => 'Running Head',
					'style_desc' => 'text style for running head at top of page (alignment controlled by running head style editor)',
					'style_prev' => 'Pack my box with five dozen liquor jugs.',
					'style_font' => 'Readers Choice',
					'style_font_size' => '14',
					'style_line_indent' => '0',
					'style_left_margin' => '0',
					'style_right_margin' => '0',
					'style_hyphen' => 'off',
					'style_runt' => 'off',
					'style_align' => 'right',
					'style_lines_before' => '0',
					'style_lines_after' => '0',
					'style_line_height' => '18',
					'style_slug' => 'pubml-running-head',
					'hide_from_section_editor' => 'true',
					'default_style' => 'normal', 
				),

			'2' => array (
					'style_name' => 'Headline (Title)',
					'style_desc' => 'Chapter and Section titles. Large, Centered text.',
					'style_prev' => 'Pack my box with five dozen liquor jugs.',
					'style_font' => 'Readers Choice',
					'style_font_size' => '28',
					'style_line_indent' => '0',
					'style_left_margin' => '0',
					'style_right_margin' => '0',
					'style_hyphen' => 'off',
					'style_runt' => 'on',
					'style_align' => 'center',
					'style_lines_before' => '0',
					'style_lines_after' => '14',
					'style_line_height' => '48',
					'style_slug' => 'pubml-section-title',
					'hide_from_section_editor' => 'false',   
					'default_style' => 'bold', 
				),
			'3' => array (
					'style_name' => 'SubHeadline (Subtitle)',
					'style_desc' => 'Subtitles. Centered text that`s smaller than title text.',
					'style_prev' => 'Pack my box with five dozen liquor jugs.',
					'style_font' => 'Readers Choice',
					'style_font_size' => '22',
					'style_line_indent' => '0',
					'style_left_margin' => '0',
					'style_right_margin' => '0',
					'style_hyphen' => 'off',
					'style_runt' => 'on',
					'style_align' => 'center',
					'style_lines_before' => '0',
					'style_lines_after' => '14',
					'style_line_height' => '48',
					'style_slug' => 'pubml-subtitle',
					'hide_from_section_editor' => 'false',
					'default_style' => 'bold', 
				),
			'4' => array (
					'style_name' => 'Epigram/Quotation',
					'style_desc' => 'Used for quotations, often at beginnings of sections. Has margin on left and right.',
					'style_prev' => 'Pack my box with five dozen liquor jugs.',
					'style_font' => 'Readers Choice',
					'style_font_size' => '18',
					'style_line_indent' => '10',
					'style_left_margin' => '20',
					'style_right_margin' => '20',
					'style_hyphen' => 'on',
					'style_runt' => 'off',
					'style_align' => 'left',
					'style_lines_before' => '0',
					'style_lines_after' => '0',
					'style_line_height' => '18',
					'style_slug' =>  'pubml-quotation' ,
					'hide_from_section_editor' => 'false',
					'default_style' => 'italic',
			),
			'5' => array (
					'style_name' => 'Epigram Byline',
					'style_desc' => 'Test Data',
					'style_prev' => 'Pack my box with five dozen liquor jugs.',
					'style_font' => 'Readers Choice',
					'style_font_size' => '18',
					'style_line_indent' => '0',
					'style_left_margin' => '20',
					'style_right_margin' => '20',
					'style_hyphen' => 'on',
					'style_runt' => 'off',
					'style_align' => 'right',
					'style_lines_before' => '0',
					'style_lines_after' => '20',
					'style_line_height' => '24',
					'style_slug' => 'pubml-quote-author',
					'hide_from_section_editor' => 'false',
					'default_style' => 'italic',
			),
			'6' => array (
					'style_name' => 'Body Text',
					'style_desc' => 'General text style used throughout the book, the default type style.',
					'style_prev' => 'Pack my box with five dozen liquor jugs.',
					'style_font' => 'Readers Choice',
					'style_font_size' => '18',
					'style_line_indent' => '10',
					'style_left_margin' => '0',
					'style_right_margin' => '0',
					'style_hyphen' => 'on',
					'style_runt' => 'off',
					'style_align' => 'justify',
					'style_lines_before' => '0',
					'style_lines_after' => '0',
					'style_line_height' => '24',
					'style_slug' => 'p',
					'hide_from_section_editor' => 'false',
					'default_style' => 'normal',
			),
			'7' => array (
					'style_name' => 'Lyrics',
					'style_desc' => 'For lyrics and poetry. First line of paragraph has negative indent.',
					'style_prev' => 'Pack my box with five dozen liquor jugs.',
					'style_font' => 'Readers Choice',
					'style_font_size' => '18',
					'style_line_indent' => '-10',
					'style_left_margin' => '30',
					'style_right_margin' => '0',
					'style_hyphen' => 'on',
					'style_runt' => 'off',
					'style_align' => 'left',
					'style_lines_before' => '0',
					'style_lines_after' => '0',
					'style_line_height' => '22',
					'style_slug' => 'pubml-lyrics',
					'hide_from_section_editor' => 'false',
					'default_style' => 'italic',
			),
			'8' => array (
					'style_name' => 'Signage',
					'style_desc' => 'Bold, centered text representing signage and labels',
					'style_prev' => 'Pack my box with five dozen liquor jugs.',
					'style_font' => 'Impact, Charcoal, sans-serif',
					'style_font_size' => '16',
					'style_line_indent' => '0',
					'style_left_margin' => '0',
					'style_right_margin' => '0',
					'style_hyphen' => 'off',
					'style_runt' => 'on',
					'style_align' => 'center',
					'style_lines_before' => '10',
					'style_lines_after' => '10',
					'style_line_height' => '22',
					'style_slug' => 'pubml-signage',
					'hide_from_section_editor' => 'false',
					'default_style' => 'bold',
			),
			'9' => array (
					'style_name' => 'Handwriting',
					'style_desc' => 'For casual letters and handwritten notes',
					'style_prev' => 'Pack my box with five dozen liquor jugs.',
					'style_font' => "'Comic Sans MS', cursive, sans-serif",
					'style_font_size' => '15',
					'style_line_indent' => '24',
					'style_left_margin' => '20',
					'style_right_margin' => '20',
					'style_hyphen' => 'off',
					'style_runt' => 'off',
					'style_align' => 'left',
					'style_lines_before' => '0',
					'style_lines_after' => '0',
					'style_line_height' => '22',
					'style_slug' => 'pubml-casual-letter',
					'hide_from_section_editor' => 'false',
					'default_style' => 'normal',
			),
            '10' => array (
					'style_name' => 'Computer Text',
					'style_desc' => 'For on-screen readout and email conversation.',
					'style_prev' => 'Pack my box with five dozen liquor jugs.',
					'style_font' => "'Courier New', Courier, monospace",
					'style_font_size' => '16',
					'style_line_indent' => '10',
					'style_left_margin' => '20',
					'style_right_margin' => '20',
					'style_hyphen' => 'off',
					'style_runt' => 'off',
					'style_align' => 'left',
					'style_lines_before' => '0',
					'style_lines_after' => '20',
					'style_line_height' => '22',
					'style_slug' => 'pubml-computer-text',
					'hide_from_section_editor' => 'false',
					'default_style' => 'normal',
			),
			'11' => array (
					'style_name' => 'Small Print',
					'style_desc' => '',
					'style_prev' => '',
					'style_font' => 'Readers Choice',
					'style_font_size' => '10',
					'style_line_indent' => '0',
					'style_left_margin' => '0',
					'style_right_margin' => '0',
					'style_hyphen' => 'off',
					'style_runt' => 'off',
					'style_align' => 'left',
					'style_lines_before' => '0',
					'style_lines_after' => '0',
					'style_line_height' => '14',
					'style_slug' => 'pubml-small-print',
					'hide_from_section_editor' => 'false',
					'default_style' => 'normal',
			),
			
		);
		
		if ($key !=  '') {
			return $pubml_default_styles[$key];	
		}else {
			return $pubml_default_styles;
		}
		
	}
	
	// Function for PubML User's Role Dropdown 
	function pubml_styles_selector($default_style='1'){
		global $pubML;
		$pubml_default_styles = pubml_styles_default_values();
		$styles = '<select id="style-val" class="text-style-menu default-style-menu" name="style" >';
			foreach($pubml_default_styles as $key=>$value){
				$selected = ($default_style == $key ) ? ' selected = "selected" ' : '' ;
				$styles .="<option $selected value=$key>".$value['style_name']."</option>";
			}
			$styles .= '</select>';

		return $styles;
	}
	// Function to call styles Dropdown 
	
	function pubml_styles_dropdown($name = '',$book_id=''){		
		global $pubML, $wpdb;
		$dropdown_id = $name.'-val';
		$query =  "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$book_id} AND {$wpdb->prefix}book_style.type='{$name}'";
		$myrows = $wpdb->get_results($query, OBJECT);
		if($myrows){
				$style_html = "<select name='$name' class='text-style-menu' id='$dropdown_id'>" ;
					foreach($myrows as $data){
						$style_data = unserialize($data->style_data);
						@$lastKey = end( array_keys($style_data));
						// print_r(array_keys($style_data)); 
					}
					foreach($style_data as $key=>$value){
						$selected = (@$default_style == $key ) ? ' selected = "selected" ' : '' ;
						$style_html .="<option $selected value=$key>".$value['style_name']."</option>";
					}
				$style_html .= '</select>';		
				return $style_html;
		}
		else{
			return pubml_styles_selector();
		}
	}	
	
	//Page styles Dropdown
	function pubml_page_styles_dropdown($name = '',$book_id=''){		
		global $pubML, $wpdb;
		$dropdown_id = $name.'-val';
		$query =  "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$book_id} AND {$wpdb->prefix}book_style.type='{$name}'";
		$myrows = $wpdb->get_results($query, OBJECT);
		$style_html .= "<select name='$name' class='page-style-menu' id='$dropdown_id'>" ;
		$style_html .= '<option value="0" selected="selected">Add New</option>';
		if($myrows){
					foreach($myrows as $data){
						$style_html .="<option value={$data->id}>".$data->style_name."</option>";
					}
		}
			$style_html .= '</select>';		
			return $style_html;
	}	
	
	//Page styles Dropdown
	function pubml_custom_import_css($zipObj, $book_id =''){		
		global $pubML, $wpdb;
		$book = get_term_by('id', $book_id, 'book');
		$style_array = $customStyles = array();	
		$custom_style = '';
				
		$custom_query = "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$book_id} AND {$wpdb->prefix}book_style.type='all-data'";
				
		$mystyles  = $wpdb->get_row($custom_query);

		if(count($mystyles)){
			$customStyles =  unserialize($mystyles->style_data);			
		}else{
			$customStyles =  PubML_default_style_data();
		}	
				
		//return($customStyles);
		$custom_image_dest = $book->slug.'/img/';	
		//exit(print_r($book));
		if($customStyles['background']['back-img-val']){
			pubml_copy_single_image($zipObj, $customStyles['background']['back-img-val'],  $custom_image_dest);						
			pubml_copy_single_image($zipObj, $customStyles['background']['custom-image-thumb'],  $custom_image_dest, 'background_custom_1.png');						
		}
		if($customStyles['background']['default-image']){
			pubml_copy_single_image($zipObj, $customStyles['background']['default-image'], $custom_image_dest);			
		}
		if($customStyles['background']['paper-img-val']){
			pubml_copy_single_image($zipObj, $customStyles['background']['paper-img-val'], $custom_image_dest);			
		}	
		
		$_pubML_margin = $customStyles['layout']['book-page-margin'];
			
			switch ($_pubML_margin) {
				case 'classic':
					$_pubML_margin_top  	= 11;
					$_pubML_margin_bottom 	= 22;
					$_pubML_margin_right 	= 17;
					$_pubML_margin_left 	= 17;
					$cover_additional_w = 34;
					$cover_additional_h = 33;
					
					break;
				case 'trade':
					$_pubML_margin_top  	= '48px';
					$_pubML_margin_bottom 	= '48px';
					$_pubML_margin_right 	= '48px';
					$_pubML_margin_left 	= '48px';
					$cover_additional_w = '96px';
					$cover_additional_h = '96px';					
					break;
				case 'custom':
					$_pubML_margin_top = (($customStyles['layout']['layout-top-margin']) ? ($customStyles['layout']['layout-top-margin']) : 0 );
					$_pubML_margin_bottom = (($customStyles['layout']['layout-bottom-margin'])? ($customStyles['layout']['layout-bottom-margin']): 0) ;
					$_pubML_margin_right = (($customStyles['layout']['layout-out-margin'])? ($customStyles['layout']['layout-out-margin']): 0);
					$_pubML_margin_left = (($customStyles['layout']['layout-in-margin'])? ($customStyles['layout']['layout-in-margin']): 0) ;
					$cover_additional_w = $customStyles['layout']['layout-out-margin'] + $customStyles['layout']['layout-in-margin'] ;
					$cover_additional_h = $customStyles['layout']['layout-bottom-margin'] + $customStyles['layout']['layout-top-margin'];
					break;	
				default:
					$_pubML_margin_top  	= 11;
					$_pubML_margin_bottom 	= 22;
					$_pubML_margin_right 	= 17;
					$_pubML_margin_left 	= 17;
					$cover_additional_w = 34;
					$cover_additional_h = 33;
			}
		
		preg_match("/(\d+)(px)?/", $_pubML_margin_top, $output_pubML_margin_top);
		preg_match("/(\d+)(px)?/", $_pubML_margin_bottom, $output_pubML_margin_bottom);
		preg_match("/(\d+)(px)?/", $_pubML_margin_right, $output_pubML_margin_right);
		preg_match("/(\d+)(px)?/", $_pubML_margin_left, $output_pubML_margin_left);
		preg_match("/(\d+)(px)?/", $cover_additional_w, $output_cover_additional_w);
		preg_match("/(\d+)(px)?/", $cover_additional_h, $output_cover_additional_h);
		
		$margin_type = (isset($output_pubML_margin_top[2])) ? $output_pubML_margin_top[2] : '%' ;
		
		
		$custom_style .= "/* Setting the less variables */ \n";
				
		$book_layout = $customStyles['layout']['book-page-size'];
		
		$_custom_scripts = '';
		$_custom_scripts .= "// Scales your PubML eBook \n";	

		$_custom_scripts .= " function resizeableWindow(){\n";	   // resizeableWindow Start
		
		$_custom_scripts .= "columntextOffset = $('#columntext').offset(); \n";
		$_custom_scripts .= "var pubMLWindowWidth = $(window).width(); \n";
		$_custom_scripts .= "var pubMLBookWidth = $('#columntext').width(); \n";
		$_custom_scripts .= "var pubMLcolWidth = $('#cover').width(); \n";
		$_custom_scripts .= "columnWidth =  pubMLBookWidth ;  \n";
		$_custom_scripts .= "columnGap = ((pubMLcolWidth - pubMLBookWidth)*3);	 \n";
		$_custom_scripts .= "totalColumnWidth = pubMLBookWidth + columnGap; \n";
			
		$_custom_scripts .= "$('#columntext').css({'-webkit-column-gap': columnGap , '-moz-column-gap': columnGap, '-ms-column-gap': columnGap, 'column-gap': columnGap, '-moz-column-width': columnWidth, '-webkit-column-width': columnWidth, '-ms-column-width': columnWidth, 'column-width': columnWidth});  \n";
		
		$_custom_scripts .= "var pubMLWinHt = $(window).height();\n";	
		$_custom_scripts .= "var pubMLWinWD = $(window).width();\n";	
		$_custom_scripts .= "var pubMLWH = (pubMLWinHt - pubMLWinHt * 0.06);\n";	
		$_custom_scripts .= "var win_ratio = pubMLWinWD / pubMLWinHt;\n";	
			
			switch ($book_layout) {
				case '69':
					$custom_style .= "@pubMLWidth : 46rem; \n@pubMLHeight : 69rem; \n@pubMLcolumnWidth: (@pubMLWidth - (@pubMLWidth * ($cover_additional_w/100)*2));  \n@pubMLColumnGap : (@pubMLWidth + (@pubMLWidth * $cover_additional_w/100));\n\n ";
					
					$_custom_scripts .= "var book_ratio = 0.67;\n";		
						
					break;
				case '57':
					$custom_style .= "@pubMLWidth : 48.15rem; \n@pubMLHeight : 69rem; \n@pubMLcolumnWidth: (@pubMLWidth - (@pubMLWidth * ($cover_additional_w/100)*2)); @pubMLColumnGap : (@pubMLWidth + (@pubMLWidth * $cover_additional_w/100));\n\n ";
					
					$_custom_scripts .= "var book_ratio = 0.71;\n";	
					
					break;
				case '11':
					$custom_style .= "@pubMLWidth : 69rem;\n@pubMLHeight : 69rem; \n@pubMLcolumnWidth: (@pubMLWidth - (@pubMLWidth * ($cover_additional_w/100)*2)); \n@pubMLColumnGap :(@pubMLWidth + (@pubMLWidth * $cover_additional_w/100));\n\n ";
					
					$_custom_scripts .= "var book_ratio = 1;\n";		
					
					break;
				case 'golden':
					$custom_style .= "@pubMLWidth : 44rem; \n@pubMLHeight : 69rem; \n@pubMLcolumnWidth: (@pubMLWidth - (@pubMLWidth * ($cover_additional_w/100)*2)); \n@pubMLColumnGap :(@pubMLWidth + (@pubMLWidth * $cover_additional_w/100));\n\n ";
										
					$_custom_scripts .= "var book_ratio = 0.60;\n";					
					
					break;
				case 'custom':
					$book_s_width  = ($customStyles['layout']['layout-img-width']) ? ($customStyles['layout']['layout-img-width']) : '46' ;
					$book_s_height = ($customStyles['layout']['layout-img-height'])? ($customStyles['layout']['layout-img-height']): '69' ;
					
					$_book_ratio = ((45/$book_s_height) * $book_s_width )."rem";
					$_book_percent = ($book_s_width / $book_s_height );
					
					$custom_style .= "@pubMLWidth : $_book_ratio; \n @pubMLHeight : 69rem; \n@pubMLcolumnWidth: (@pubMLWidth - (@pubMLWidth * ($cover_additional_w/100)*2)); \n@pubMLColumnGap : (@pubMLWidth + (@pubMLWidth * $cover_additional_w/100));\n\n ";
					
					$_custom_scripts .= "var book_ratio = $_book_percent;\n";								
					
					break;	
				default:
					$custom_style .= "@pubMLWidth : 46rem; \n@pubMLHeight : 69rem; \n@pubMLcolumnWidth: (@pubMLWidth - (@pubMLWidth * ($cover_additional_w/100)*2)); \n@pubMLColumnGap : (@pubMLWidth + (@pubMLWidth * $cover_additional_w/100));\n\n ";
					
					$_custom_scripts .= "var book_ratio = 0.67;\n";					
			}
				
			$_custom_scripts .= " 	if( win_ratio < book_ratio){ \n ";
			$_custom_scripts .= " 		pubMLWidth = (pubMLWinWD - pubMLWinWD * 0.06); \n ";
			$_custom_scripts .= " 		pubMLWH = pubMLWidth * (1/book_ratio); \n ";
			$_custom_scripts .= " 		var PubMLContentArea = pubMLWidth; \n ";
			$_custom_scripts .= " 	}else{ \n ";
			$_custom_scripts .= " 	var PubMLContentArea = pubMLWH * book_ratio; \n } \n ";			
							
		if($margin_type != 'px'){
			$_custom_scripts .= "var PubMLpageMargin = pubMLWH * ($output_cover_additional_h[1]/100) ;\n";		
			$_custom_scripts .= "var PubMLpageMargintop = pubMLWH * ( $output_pubML_margin_top[1]/100) ;\n";
			$_custom_scripts .= "var PubMLpageMarginright = PubMLContentArea *($output_pubML_margin_right[1]/100) ;\n";
			$_custom_scripts .= "var PubMLpageMarginbottom = pubMLWH * ( $output_pubML_margin_bottom[1]/100) ;\n";
			$_custom_scripts .= "var PubMLpageMarginleft = PubMLContentArea * ($output_pubML_margin_left[1]/100) ;\n";
			$_custom_scripts .= "$('#columntext').css({'margin-top' : PubMLpageMargintop, 'margin-right': PubMLpageMarginright, 'margin-bottom':PubMLpageMarginbottom, 'margin-left' : PubMLpageMarginleft});\n";	
			$_custom_scripts .= "var pagination_height = $('.pageNumber').height();\n";
			$_custom_scripts .= "$('.pageNumber').css('bottom', ((PubMLpageMarginbottom/2)-(pagination_height/2)));\n";
		}else{		
			$_custom_scripts .= "var PubMLpageMargin = $output_cover_additional_h[1] ;\n";		
			$_custom_scripts .= "$('.pageNumber').css('bottom', ($output_pubML_margin_bottom[1]/2)- 10 );\n";								
		}	
		
		$_custom_scripts .= "$('#columntext').height(pubMLWH);\n";							
		$_custom_scripts .= "$('#columntext').css('max-height', pubMLWH- PubMLpageMargin);\n";							
		$_custom_scripts .= "$('.book').height(pubMLWH).width(PubMLContentArea);\n";							
		$_custom_scripts .= "$('.main_container').height(pubMLWH).width(PubMLContentArea);\n";							
		$_custom_scripts .= " $('html').css('font-size', ((pubMLWH/609) * 62.5)+'%' );\n";							
		$_custom_scripts .= "$('#cover').height(pubMLWH).width(PubMLContentArea);\n";						
		
		$_custom_scripts .= "};	\n";		 // function resizeableWindow(){ End		
		
		$custom_style .= ".book { width:@pubMLWidth; height:@pubMLHeight; }\n\n" ;
			
		$custom_style .= "#cover { width:@pubMLWidth; height:@pubMLHeight ; overflow: hidden;}\n\n" ;
		
		$margin_details = "margin: $output_pubML_margin_top[1]".$margin_type." $output_pubML_margin_right[1]".$margin_type." $output_pubML_margin_bottom[1]".$margin_type." $output_pubML_margin_left[1]".$margin_type.";"; 
		
		if($margin_type != 'px'){
			$MC_content_area = (100 - $cover_additional_h).'%';
		} else{
			$MC_content_area = "@pubMLHeight - ($output_cover_additional_h[1]/7)";
		}	
		$custom_style .= "#columntext {height:@pubMLHeight;  -webkit-column-width: @pubMLcolumnWidth;  -webkit-column-gap: @pubMLColumnGap; -webkit-column-rule: 0;     -webkit-column-count: auto; 	-webkit-column-fill:auto;   -moz-column-width: @pubMLcolumnWidth;   -moz-column-gap: @pubMLColumnGap;    -moz-column-rule: 0;     -moz-column-count: auto; 	-moz-column-fill:auto;     -ms-column-width: @pubMLcolumnWidth;    -ms-column-gap: @pubMLColumnGap;    -ms-column-rule: 0;     -ms-column-count: auto;	-ms-column-fill:auto;    column-width: @pubMLcolumnWidth;   column-gap: @pubMLColumnGap;   column-rule: 0;     column-count: auto;	column-fill:auto;	overflow:visible;	position:relative; $margin_details max-height: $MC_content_area; }\n\n" ;
		
		$custom_style .= ".bookFont {font-family: 'Crimson Text', Georgia, serif;}\n" ;
		$custom_background = basename($customStyles['background']['back-img-val']);
		$default_background = basename($customStyles['background']['default-image']);
		$cus_background = basename($customStyles['background']['custom-image']);	
		
		if($customStyles['background']['background-type']== 'full'){
			$custom_style .= "body{overflow:hidden;  background:url('../img/$custom_background') no-repeat fixed center center transparent; margin:0; background-size: cover;}\n";
			$custom_style .= ".topbg1{background:url('../img/$custom_background') no-repeat fixed center center transparent; margin:0; background-size: cover;}\n";
			$custom_style .= ".topbg2{background:url('../img/$default_background') no-repeat fixed center center transparent; margin:0; background-size: cover;}\n";
		}
		if($customStyles['background']['background-type']== 'tile'){
			$custom_style .= "body{overflow:hidden; background:url('../img/$custom_background') repeat transparent;margin:0;}\n";
			$custom_style .= ".topbg1{background:url('../img/$custom_background') repeat transparent;margin:0;}\n";
			$custom_style .= ".topbg2{background:url('../img/$default_background') repeat transparent;margin:0;}\n";
		}

		if($customStyles['background']['paper-img-val']){
			$paper_background = basename($customStyles['background']['paper-img-val']);
			/*$custom_style .= ".toppbg2{background:url('../img/$paper_background') repeat scroll left top #FFFBE7}\n";*/
			$custom_style .= ".toppbg2{background:#FFF}\n";	
		}	
		if($customStyles['background']['def-paper-img-val']){
			$paper_color = ($customStyles['background']['color-val'])? '#'.$customStyles['background']['color-val'] : '#FFFBE7' ;
			$def_paper_img = basename($customStyles['background']['def-paper-img-val']);	
			$def_paper_img_copy = $customStyles['background']['def-paper-img-val'];
			$custom_image_destination = $book->slug.'/img/';	
			pubml_copy_single_image($zipObj, $def_paper_img_copy , $custom_image_destination);
			$custom_style .= ".toppbg1{background:url('../img/$def_paper_img') repeat scroll left top $paper_color;}\n";			
		}	
		
			
		// Chapter Ornament CSS
		$chapt_ornament = $customStyles['text_style']['orn-style-val'];
		if($chapt_ornament){				
			$chapt_ornament_img = basename($chapt_ornament);			
			pubml_copy_single_image($zipObj, $chapt_ornament, $custom_image_dest);			
			$custom_style .= ".pubml-chapter-ornament{background:url('../img/$chapt_ornament_img') no-repeat Center top;border: 0;display: block;width: 95%;height:8rem;margin: 10px auto;text-align: center;background-size:auto 100%;	}\n";	
		}
		// Seperator Ornament CSS
		$sept_ornament = $customStyles['seperator_ornament']['custom-separator'];
		if($sept_ornament){	
			$sept_ornament_path = ($sept_ornament == 'sep_1') ? PUBML_BASE_URL.'/images/separator_ornament_1.png' : $customStyles['seperator_ornament']['upload-sep-link-val'];
			$sept_ornament_img = basename($sept_ornament_path);			
			pubml_copy_single_image($zipObj, $sept_ornament_path, $custom_image_dest);			
			$custom_style .= ".pubml-separator-ornament{background:url('../img/$sept_ornament_img') no-repeat Center top;border: 0;display: block;width: 95%; height:3rem;margin: 1rem auto;text-align: center; background-size: auto 100%;	}\n";	
		}
		// Page Number CSS
		$page_number = $customStyles['page_numbers'];
		if (!empty($page_number)){
			$custom_style .= ".pageNumber{";
			$custom_style .= ($customStyles['page-number-font-menu'] == 'Readers Choice') ? ".bookFont; " : "font-family: ".stripslashes(str_replace('\\', '', $customStyles['page-number-font-menu']))." !important;" ;
			
			$custom_style .= " font-size: ".(($customStyles['page_numbers']['style-two-font-val'])? (($customStyles['page_numbers']['style-two-font-val'])/10) : '1.2'). 'rem; ';
			$custom_style .= " text-align: ".(($customStyles['page_numbers']['book-hpos'])? ($customStyles['page_numbers']['book-hpos']) : 'center') . ";";
			
			if($customStyles['page_numbers']['font-bold'] == 'bold'){					
					$custom_style .= " font-weight: bold; ";
				}else{				
					$custom_style .= " font-weight: bold; ";
				}
			
			if($customStyles['page_numbers']['font-italic'] == 'italic'){					
					$custom_style .= " font-style: italic; ";
				}else{				
					$custom_style .= " font-style: italic; ";
				}
				
			$custom_style .= "}\n";
			
			$pre_text  = (($customStyles['page_numbers']['text-before'])? $customStyles['page_numbers']['text-before'] : ' ');
			$post_text = (($customStyles['page_numbers']['text-after']) ? $customStyles['page_numbers']['text-after']  : ' ');
			
			$_custom_scripts .= "var pubMLpaginationTextLeft = '$pre_text';" ; 	// Pre pagination text
			$_custom_scripts .= "var pubMLpaginationTextRight = '$post_text';";	// Post pagination text
			
			$_custom_scripts .= "\n\n";

			$_custom_scripts .= "$(document).ready(function (){ \n";
			$_custom_scripts .= "resizeableWindow();\n";
			$_custom_scripts .= "});\n";	

			$_custom_scripts .= "$(window).resize(function() { \n";
			$_custom_scripts .= "resizeableWindow(); \n";
			$_custom_scripts .= "$('#columntext').css({'left': '0'}); \n";
			$_custom_scripts .= "currentPage = 1; //reset page number \n";
			$_custom_scripts .= "updatePageNumber(); //update page number text \n";
			$_custom_scripts .= "}); \n";	
			
		}
		
		// $_custom_scripts = iconv("UTF-8", "ascii//TRANSLIT", $_custom_scripts);
		$zip_name =  $book->slug."/scripts/pubml_custom.js";								
		$zipObj->addFromString($zip_name, $_custom_scripts);
		
		// running_head CSS
		$page_running_head = $customStyles['running_head']['book-head-loc'];
		$page_running_head_img = ($customStyles['running_head']['orn-head-val']) ? $customStyles['running_head']['orn-head-val'] :  $customStyles['running_head']['def-orn-head-val'] ;
		
		$running_ornament_img = basename($page_running_head_img);			
		pubml_copy_single_image($zipObj, $page_running_head_img, $custom_image_dest);
		
		if(empty($customStyles['running_head']['no-head'])){
			switch ($page_running_head) {
				case 'left':
					$custom_style .= ".pubml-running-head{text-align:left !important;}\n ";
					$custom_style .= "#runningHead { left: 6%}\n" ;
					if(empty($customStyles['running_head']['no-head-ornamnet'])){
						$custom_style .= ".pubml-running-head{padding-left: 3rem;}\n ";						
						$custom_style .= ".pubml-running-head:before {	background:url('../img/$running_ornament_img') no-repeat transparent; content: ' '; height: 2.5rem; position: absolute; width: 2.5rem; z-index: 1; left:0; background-size: auto 100%; background-position:left; }\n\n";
					}
					break;
				case 'center':
					$custom_style .= "#runningHead { width: 100%;}\n" ;
					$custom_style .= ".pubml-running-head{text-align:center !important; padding: 0px;}\n\n ";
					break;
				case 'right':
					$custom_style .= ".pubml-running-head{text-align:right !important;}\n";
					$custom_style .= "#runningHead { right: 6%}\n" ;
					if(empty($customStyles['running_head']['no-head-ornamnet'])){
						$custom_style .= ".pubml-running-head{padding-right: 3rem;}\n";
						$custom_style .= ".pubml-running-head:after {	background:url('../img/$running_ornament_img') no-repeat transparent; content: ' '; height: 2.5rem; position: absolute; width: 2.5rem; z-index: 1;right: 0; background-size: auto 100%; background-position:right; }\n\n";
					}
					break;
				default:
					$custom_style .= ".pubml-running-head{text-align:right !important;}\n";
					$custom_style .= "#runningHead { right: 6%}\n" ;
					if(empty($customStyles['running_head']['no-head-ornamnet'])){
						$custom_style .= ".pubml-running-head{padding-right: 3rem;}\n";
						$custom_style .= ".pubml-running-head:after {	background:url('../img/$running_ornament_img') no-repeat transparent; content: ' '; height: 2.5rem; position: absolute; width: 2.5rem; z-index: 1; right: 0; background-size: auto 100%; background-position:right; 	}\n\n";
					}
			}	
		}else{
			$custom_style .= ".pubml-running-head{display:none !important;}\n";
		}
		// Dropcaps CSS
		$ini_caps = $customStyles['initial_caps']['capitals-val'];
		if (!empty($ini_caps)){
			$zipObj->addEmptyDir($book->slug.'/css/fonts');
			if($ini_caps == 'dropcaps_4'){
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/sesame-webfont/sesame-webfont.eot', $book->slug.'/css/fonts/sesame-webfont.eot');
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-sesame/sesame-webfont.svg', $book->slug.'/css/fonts/sesame-webfont.svg');
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-sesame/sesame-webfont.woff', $book->slug.'/css/fonts/sesame-webfont.woff');
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-sesame/sesame-webfont.ttf', $book->slug.'/css/fonts/sesame-webfont.ttf');
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-sesame/sesame-webfont.ttf', $book->slug.'/css/fonts/sesame-webfont.ttf');
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-sesame/index.html', $book->slug.'/css/fonts/index.html');
				$caps_font = 'sesame';
				$caps_font_name = 'sesame-webfont';
			}
			else if($ini_caps == 'dropcaps_3'){
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-eileen/eicap___-webfont.eot', $book->slug.'/css/fonts/eicap___-webfont.eot');
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-eileen/eicap___-webfont.svg', $book->slug.'/css/fonts/eicap___-webfont.svg');
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-eileen/eicap___-webfont.woff', $book->slug.'/css/fonts/eicap___-webfont.woff');
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-eileen/eicap___-webfont.ttf', $book->slug.'/css/fonts/eicap___-webfont.ttf');
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-eileen/index.html', $book->slug.'/css/fonts/index.html');
				$caps_font = 'eileencapsregular';
				$caps_font_name = 'eicap___-webfont';
			}
			else if($ini_caps == 'dropcaps_2'){
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-goudy/goudyini-webfont.eot', $book->slug.'/css/fonts/goudyini-webfont.eot');
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-goudy/goudyini-webfont.svg', $book->slug.'/css/fonts/goudyini-webfont.svg');
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-goudy/goudyini-webfont.woff', $book->slug.'/css/fonts/goudyini-webfont.woff');
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-goudy/goudyini-webfont.ttf', $book->slug.'/css/fonts/goudyini-webfont.ttf');
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-goudy/index.html', $book->slug.'/css/fonts/index.html');
				$caps_font = 'goudy_initialenregular';
				$caps_font_name = 'goudyini-webfont';
			}
			else if($ini_caps == 'dropcaps_1'){
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-kramer/kramer__-webfont.eot', $book->slug.'/css/fonts/kramer__-webfont.eot');
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-kramer/kramer__-webfont.svg', $book->slug.'/css/fonts/kramer__-webfont.svg');
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-kramer/kramer__-webfont.woff', $book->slug.'/css/fonts/kramer__-webfont.woff');
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-kramer/kramer__-webfont.ttf', $book->slug.'/css/fonts/kramer__-webfont.ttf');
				$zipObj->addFile(PUBML_BASE_DIR.'/dropcap_font/webfontkit-kramer/index.html', $book->slug.'/css/fonts/index.html');
				$caps_font = 'kramerregular';
				$caps_font_name = 'kramer__-webfont';
			}
			$custom_style .= ".pubml-dropcaps{font-family:'$caps_font'; font-size: 6.15rem;  display:block; position: relative; float:left; line-height:4.7rem; font-weight:lighter; -webkit-font-smoothing:antialiased; text-shadow: 1px 1px 1px rgba(0,0,0,0.004);}\n";			
			$custom_style .= "@font-face {
									font-family: '$caps_font';
									src: url('fonts/$caps_font_name.eot');
									src: url('fonts/$caps_font_name.eot?#iefix') format('embedded-opentype'),
										 url('fonts/$caps_font_name.woff') format('woff'),
										 url('fonts/$caps_font_name.ttf') format('truetype'),
										 url('fonts/$caps_font_name.svg#eileencapsregular') format('svg');
									font-weight: normal;
									font-style: normal;

								}\n";
			
		}				 
		
		return	$custom_style;
	}	
	
	//Page styles Dropdown
	function pubml_style_editor_css($book_id =''){		
		global $pubML, $wpdb;
		$book = get_term_by('id', $book_id, 'book');
		$style_array = $customStyles = array();	
		$custom_style = "/*-----Custom Style Editor CSS Generated -----*/\n" ;
		$custom_image_dest = $book->slug.'/img/';	// Destination folder path	
				
		$custom_query =  "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$book_id} AND {$wpdb->prefix}book_style.type='style'";
	
		$mystyles  = $wpdb->get_row($custom_query);
		
			if(count($mystyles)){
				$customStyles =  unserialize($mystyles->style_data);			
			}else{
				$customStyles = pubml_styles_default_values();
			}		
			
	
		foreach($customStyles as $key => $value){
			if($value['style_slug']!= 'p')
				$class_name = ($value['style_slug']) ? '.'.$value['style_slug'] : '.pubml-'.sanitize_title($value['style_name']);
			else
				$class_name = 'p';
				
			$custom_style .=  $class_name."{";		
					
				$margin_left = ($value['style_left_margin']) ? ($value['style_left_margin']/10) : 0 ; 
				$margin_right = ($value['style_right_margin']) ? ($value['style_right_margin']/10) : 0 ; 
				$margin_top = ($value['style_lines_before']) ? ($value['style_lines_before']/10) : 0 ; 
				$margin_bottom = ($value['style_lines_after']) ? ($value['style_lines_after']/10) : 0 ; 
		
				$custom_style .= " margin: $margin_top"."rem $margin_right"."rem $margin_bottom"."rem $margin_left"."rem ; ";
				
				$custom_style .= ($value['style_font'] == 'Readers Choice') ? ".bookFont; " : "font-family: ".stripslashes($value['style_font'])." !important;" ; 
				$custom_style .= 'text-align: '.(($value['style_align']) ? $value['style_align'] : '').';' ; 
				$custom_style .= 'font-size: '.(($value['style_font_size']) ? ($value['style_font_size']/10) : '' ).'rem;';  
				
				$custom_style .= ($value['style_hyphen']== 'on') ? ' -webkit-hyphens: auto; -moz-hyphens: auto;	hyphens: auto; ' : ' -webkit-hyphens: none; -moz-hyphens: none;	hyphens: none; ';
				$custom_style .= ($value['style_line_height']) ? " line-height: ".($value['style_line_height']/10)."rem; " : "";
				$custom_style .= ($value['style_line_indent']) ? " text-indent: ".($value['style_line_indent']/10)."rem; " : " text-indent: 0;";
				
				if($value['default_style'] == 'bold'){					
					$custom_style .= " font-weight: bold; ";
				}else{				
					$custom_style .= ($value['default_style']) ? " font-style: ".($value['default_style'])."; " : " font-style: normal; ";
				}
				
			$custom_style .= "}\n";	 	
			 	
		}	
		
		return	$custom_style;
	}	

/*****************************************************************************************/
/**********  Function end to create the Navigation Tabs for exported PubML  *************/
/*****************************************************************************************/	

function pubml_navigation_tabs($book_id, $zip){
	global $wpdb, $pubml;
	$book = get_term_by('id', $book_id, 'book');
	
	$tabs_posts 	 = get_all_posts_term($book_id, 'pubml-navigation');	// All Navigation tabs Array
	
	$nav_tabs = array();
	if(count($tabs_posts)){		
		foreach ($tabs_posts as $post) {
			$post_id = $post->ID; 	// Get the original post id 
			$post = get_post( $post_id ); 	//and all the original post data then
			
			// if post data exists, create the post duplicate
			if (isset( $post ) && $post != null) {
			$updated_post_content = pubml_chapter_toc_images($zip,$book_id,$book->slug,$post->post_content);
				$nav_tabs[] = array(
					'slug'=> $post->post_name, 'name'=> $post->post_title, 'post_content'   => wpautop($updated_post_content)	
				);
			}
		}
	}
	$custom_js = "// Tabs Array\n";
	$custom_js .= " WebFontConfig = { google: { families: [ 'Crimson+Text:400,400italic,600,600italic:latin' ";
	
	
	$pubml_fonts = get_option( 'pubml_fonts' );
	$_pubml_fonts = (empty( $pubml_fonts )) ? pubml_styles_default_fonts() : $pubml_fonts  ;
		
	if( !empty( $_pubml_fonts )){
		foreach($_pubml_fonts as $k => $v){				
			if( !$v['font_type']){
				preg_match("/\?family=(.*)\' rel/", stripslashes($v['link']), $font_matches);
				$custom_js .= ", '$font_matches[1]'";
			}
		}
	}
	$custom_js .= "] } };";
	
	
	
	if(count(@$nav_tabs)){
		$custom_js .= "var nav_tabs = ".json_encode($nav_tabs).";\n\n\n";
	}
		
	$navpanel_js = "// PubML Navigations scripts\n";
	
	$navpanel_js .= "$(document).ready(function(){\n";
		$navpanel_js .= "$('.menutabs').click(function(){\n";
			$navpanel_js .= "if($(this).parent().find('.navpanel').css('display')=='block'){	$('.navpanel').slideUp(100);	}\n else{";
				$navpanel_js .= "$('.navpanel').slideUp(100); \n ";
				$navpanel_js .= "var pubML_navpanel = $(this).parent().find('.navpanel'); \n ";
				$navpanel_js .= "pubML_navpanel.slideDown(100); 	\n ";		
				$navpanel_js .= "var menu_offset =  pubML_navpanel.offset(); \n ";
				$navpanel_js .= "var win_width = $(window).width(); \n ";	
				
				$navpanel_js .= "var nav_height = (($(window).height()) - menu_offset.top - 20); \n ";			
				$navpanel_js .= "if( win_width < 640) {  \n $('.scroll_panel').height('auto').css('max-height',nav_height);  \n} \n ";			
									
				$navpanel_js .= "if(menu_offset.left > (win_width/2)) { \n ";	  
				$navpanel_js .= "	pubML_navpanel.css({'right':'0', 'left':'auto'}); \n ";	
				$navpanel_js .= "} \n ";				
			$navpanel_js .= "}\n";
		$navpanel_js .= "});\n";
	$navpanel_js .= "});\n";
	$textStyles = array();
	$txtst_query = "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$book_id} AND {$wpdb->prefix}book_style.type='style'";								
	$txtstyles  = $wpdb->get_row($txtst_query);
	if(count($txtstyles)){
		$textStyles =  unserialize($txtstyles->style_data);			
	}else{
		$textStyles =  pubml_styles_default_values();
	}
		$classArray = array();
		foreach($textStyles as $key => $value){
			if($value['style_runt'] == 'on'){
				if($value['style_slug']!= 'p')
					$class_name = ($value['style_slug']) ? '.'.$value['style_slug'] : '.pubml-'.sanitize_title($value['style_name']);
				else
					$class_name = 'p';
				$classArray[] = $class_name;	
			}	
		}			
	$runt = implode(",",$classArray);
	
	
	$navpanel_js .= "\n\n// Runt Control\n";	
	$navpanel_js .= "function runt_control(){\n";	
		$navpanel_js .= "$('$runt').each(function() {\n";	
			$navpanel_js .= "var wordArray = $(this).html().split(' ');\n";	
			$navpanel_js .= "if (wordArray.length > 1) {\n";	
			$navpanel_js .= "wordArray[wordArray.length-2] += '&nbsp;' + wordArray[wordArray.length-1];\n";	
			$navpanel_js .= "wordArray.pop();\n";	
			$navpanel_js .= "$(this).html(wordArray.join(' '));\n";	
			$navpanel_js .= "}\n";	
		$navpanel_js .= "});	\n";	
	$navpanel_js .= "}	\n";	
	
	//$custom_js = 'Completed';							
		$custom_js = iconv("UTF-8", "ascii//TRANSLIT", $custom_js);
		$zip_name =  $book->slug."/scripts/pubml_tabs.js";								
		$zip->addFromString($zip_name, $custom_js);	

	//$navpanel_js = 'PubML Navigations';							
		$navpanel_js = iconv("UTF-8", "ascii//TRANSLIT", $navpanel_js);
		$zip_name =  $book->slug."/scripts/pubml_navpanel.js";								
		$zip->addFromString($zip_name, $navpanel_js);	
	
	return true;
}

function pubml_chapter_toc_images($zipObj,$book_id='',$book_slug='',$post_content){
			$szPostContent = $post_content;
			$szSearchPattern = '/src="http([^"]+)/i';
			preg_match_all( $szSearchPattern, $szPostContent, $aPics );
			$iNumberOfPics = count($aPics[0]);
			if ( $iNumberOfPics > 0 ) {
				 for ( $i=0; $i < $iNumberOfPics ; $i++ ) {
					  preg_match('/src="([^"]+)/i',$aPics[0][$i], $img_src);
			          $origImageSrc = str_ireplace( 'src="', '',  $img_src[0]);
						 $htmlDirInfo = pathinfo($origImageSrc);
						$htmlDir = preg_replace('#^[/\.]+#i', "", $htmlDirInfo["dirname"]);
						if (strpos($htmlDir, 'http://') !== false || strpos($htmlDir, 'https://') !== false ){
							$imgpath = explode('://',$htmlDir);
							$zipObj->addEmptyDir($book_slug.'/images/'.$imgpath[0].'/'.$imgpath[1]);
							$dest = $book_slug.'/images/'.$imgpath[0].'/'.$imgpath[1].'/';	
							pubml_copy_single_image($zipObj, $origImageSrc,$dest);
						 }
				 }
			preg_match_all("/(<img[^>]*src=[\"|\'](.*?)[\"|\'][^>]*>)/", $szPostContent, $dimensions, PREG_SET_ORDER);
			$pattern = array();
			$replacement =array();
			for($i=0;$i<sizeof($dimensions);$i++){
				list($width, $height) = @getimagesize($dimensions[$i][2]);	
				preg_match('/(class=["\'](.*?)["\'])/', $dimensions[$i][0], $class);  
				if( count($class) ){
					$class_split = preg_split('/["\']/', $class[0]); // split by quotes
					$class_img = $class_split[1]; 
				}else{
					$class_img = '';
				}				
				$pattern[] = $dimensions[$i][0];
				$replacement[] = '<div style="width: '.$width.'; height: '.$height.';" class="article-img '.$class_img .'" >'.$dimensions[$i][0].'</div>';
				$fullcontent = str_replace( $pattern, $replacement, $szPostContent );
			}
			
		$content = str_replace(array('src="http://','src="https://'), array('src="images/http/','src="images/https/'), $fullcontent);
				
	   }
	else{
		$content = $szPostContent;
	}
	return $content;
}

/*
	Deafult styles drop down
*/
	function pubml_unregistered_chapters_preview(){

		 $chapters_array = array(		
			'Chapter_1' => (object)Array(
					'ID' => '1',
					'post_title' => 'Chapter One',
					'post_name' => 'chapter-one',
					'post_content' => '<div class="pubml-chapter-ornament"></div>
									<p class="pubml-section-title">Chapter One</p>
									<p class="pubml-subtitle">Unregistered Preview</p>
									<p class="noIndent"><span class="pubml-dropcaps">P</span><span class="pubml-smallcaps">lease register</span> your PubML Publishing tools plugin to enjoy a full preview of your books. If you`re still evaluating PubML, this preview will display your custom ornaments and text styles but not your custom content.</p><div class="pubml-separator-ornament"></div><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent vitae eros a quam porttitor vestibulum. Morbi sit amet orci id elit suscipit bibendum. Suspendisse lacinia ultricies posuere. Donec ornare tortor bibendum bibendum facilisis. Vivamus in suscipit est. Mauris vel accumsan lorem, et blandit sapien. Nullam velit lectus, tincidunt et mollis nec, ultricies in elit. Quisque eu justo nunc. In adipiscing odio arcu, vitae adipiscing nisl porttitor at. Quisque eget gravida lectus. Ut tristique nisl et nibh eleifend fringilla a vitae justo. Quisque suscipit dapibus ante. In ultricies mauris augue, eu malesuada justo tincidunt vitae. Ut diam elit, mollis vitae auctor sed, tristique nec purus. Praesent consectetur egestas turpis, nec aliquam justo adipiscing quis. Aenean pulvinar leo et auctor lacinia.</p>
									<p>Donec eu fringilla nulla. Nunc eget elit id augue eleifend condimentum porttitor id eros. Sed pellentesque convallis magna nec vulputate. Quisque quam est, mollis consequat velit eget, laoreet fringilla odio. Aliquam euismod, quam sit amet dignissim placerat, lorem erat varius nunc, sit amet lobortis sapien lacus molestie lorem. Nunc eleifend velit lorem, ut tempus arcu dapibus a. Curabitur et luctus lectus, sed lacinia tellus. Ut egestas vel est ac iaculis. Pellentesque viverra metus eget arcu venenatis, at sagittis nulla rhoncus. In pharetra ornare purus, ut pharetra augue blandit in. Maecenas auctor neque id tellus venenatis sollicitudin. Etiam rhoncus sapien ut nisl eleifend gravida. Etiam nibh arcu, elementum nec tincidunt at, adipiscing ac est.</p>
									<p>Vivamus lacus ipsum, vestibulum et vehicula scelerisque, semper id risus. Morbi elit neque, porta sed condimentum sed, mattis at ante. Etiam cursus est sit amet rhoncus sodales. Fusce hendrerit augue ac sem consequat, at mollis magna pharetra. Donec at congue mi, nec suscipit justo. Vivamus tincidunt arcu sed bibendum dignissim. Duis commodo luctus felis sit amet venenatis. Duis quis quam a elit fringilla interdum. Phasellus sed arcu rutrum, cursus nisl at, cursus nisi. Morbi rutrum augue ut nibh hendrerit, eu accumsan turpis sollicitudin. Duis tincidunt tellus eget odio placerat, in lobortis enim lobortis.</p>

									<p>Ut vitae tincidunt nunc, id bibendum eros. Maecenas facilisis porttitor vehicula. Quisque commodo pellentesque felis. Duis quis nibh ipsum. Nulla gravida, neque a aliquam hendrerit, libero nisl pretium nibh, quis pharetra arcu nulla ut dui. Nunc leo dui, elementum vel placerat non, ultricies sed dui. Donec semper odio aliquam ante vulputate tempus sit amet ac velit. Aliquam feugiat urna a libero fermentum pharetra.</p>

									<p>Donec laoreet erat ut sapien accumsan porttitor. In rutrum mi eget diam imperdiet, non porttitor velit rhoncus. Cras rhoncus odio elit. Praesent semper orci orci, non iaculis massa viverra et. Mauris dolor metus, interdum in scelerisque ac, fermentum at odio. Nullam rutrum faucibus mi, et fringilla metus fringilla eget. Fusce porttitor lorem a hendrerit consequat. In non orci luctus, euismod sem quis, faucibus libero. Nullam vestibulum, augue ut aliquet laoreet, purus velit tempor tellus, eget suscipit risus nisl suscipit dui. Aliquam diam nisi, condimentum eu est sed, ultricies egestas turpis.</p>

									<p>Nunc tempus nisi a elit ornare commodo. Ut lacinia libero sed eros molestie mollis. Etiam bibendum rhoncus nisi sit amet sollicitudin. Donec vulputate a sapien eget euismod. Donec mi enim, gravida eget euismod non, molestie a metus. Suspendisse ac arcu venenatis, sollicitudin libero non, feugiat lorem. Nunc vel justo id risus faucibus volutpat nec in felis. Morbi malesuada non tellus vel rhoncus. Vestibulum quam turpis, suscipit id lacinia eget, tristique posuere tellus. Etiam id gravida risus. Proin ut odio at dui accumsan vehicula.</p>

									<p>Pellentesque interdum erat ut odio commodo eleifend. Etiam arcu lectus, tristique in tellus quis, vulputate vehicula arcu. Proin eu orci consequat, adipiscing lorem dignissim, viverra nulla. Nunc venenatis mi vitae arcu pretium, bibendum semper turpis congue. Mauris in lacus ut elit vestibulum sagittis. Curabitur porta, orci lacinia congue dapibus, sem velit tincidunt enim, nec dictum eros mauris ut dui. Sed tristique malesuada ante, et commodo arcu molestie scelerisque. Nulla augue nunc, laoreet a magna sit amet, dapibus gravida neque. Duis mattis, ligula id fermentum hendrerit, arcu ante sodales est, et mattis massa tortor ac ante. Cras nibh lorem, dignissim sed iaculis id, viverra mollis libero. Fusce sed pellentesque lorem.</p>

									<p>Aliquam molestie nulla ac augue convallis, nec feugiat quam tincidunt. Maecenas turpis erat, bibendum sed arcu in, bibendum ultricies magna. Quisque in tellus sed justo placerat faucibus quis eu neque. Sed non semper nisl. Vestibulum vel felis eget elit adipiscing laoreet. Nam rhoncus feugiat mauris nec dignissim. Nulla eu lorem enim. Nam sagittis erat vitae est gravida commodo. Mauris vitae turpis sed enim semper suscipit nec sit amet libero. Nunc at neque hendrerit, blandit mauris in, consequat lacus. Nullam vel elit sit amet tellus tristique condimentum. Donec elit elit, condimentum sed dolor ut, euismod pharetra est. Pellentesque ultrices nisl nisi, ut adipiscing eros vulputate non. Proin in ultrices arcu, fermentum eleifend turpis. Aenean lacinia turpis eget ullamcorper gravida.</p>'
		),

			'Chapter_2' => (object)Array(
					'ID' => '2',
					'post_title' => 'Chapter Two',
					'post_name' => 'chapter-two',
					'post_content' => '<div class="pubml-chapter-ornament"></div>
									<p class="pubml-section-title">Chapter Two</p>
									<p class="pubml-subtitle">Unregistered Preview</p>
									<p class="noIndent"><span class="pubml-dropcaps">P</span><span class="pubml-smallcaps">lease register</span> your PubML Publishing tools plugin to enjoy a full preview of your books. If you`re still evaluating PubML, this preview will display your custom ornaments and text styles but not your custom content.</p><div class="pubml-separator-ornament"></div>
									<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent vitae eros a quam porttitor vestibulum. Morbi sit amet orci id elit suscipit bibendum. Suspendisse lacinia ultricies posuere. Donec ornare tortor bibendum bibendum facilisis. Vivamus in suscipit est. Mauris vel accumsan lorem, et blandit sapien. Nullam velit lectus, tincidunt et mollis nec, ultricies in elit. Quisque eu justo nunc. In adipiscing odio arcu, vitae adipiscing nisl porttitor at. Quisque eget gravida lectus. Ut tristique nisl et nibh eleifend fringilla a vitae justo. Quisque suscipit dapibus ante. In ultricies mauris augue, eu malesuada justo tincidunt vitae. Ut diam elit, mollis vitae auctor sed, tristique nec purus. Praesent consectetur egestas turpis, nec aliquam justo adipiscing quis. Aenean pulvinar leo et auctor lacinia.</p>
									
									<p>Donec eu fringilla nulla. Nunc eget elit id augue eleifend condimentum porttitor id eros. Sed pellentesque convallis magna nec vulputate. Quisque quam est, mollis consequat velit eget, laoreet fringilla odio. Aliquam euismod, quam sit amet dignissim placerat, lorem erat varius nunc, sit amet lobortis sapien lacus molestie lorem. Nunc eleifend velit lorem, ut tempus arcu dapibus a. Curabitur et luctus lectus, sed lacinia tellus. Ut egestas vel est ac iaculis. Pellentesque viverra metus eget arcu venenatis, at sagittis nulla rhoncus. In pharetra ornare purus, ut pharetra augue blandit in. Maecenas auctor neque id tellus venenatis sollicitudin. Etiam rhoncus sapien ut nisl eleifend gravida. Etiam nibh arcu, elementum nec tincidunt at, adipiscing ac est.</p>

									<p>Vivamus lacus ipsum, vestibulum et vehicula scelerisque, semper id risus. Morbi elit neque, porta sed condimentum sed, mattis at ante. Etiam cursus est sit amet rhoncus sodales. Fusce hendrerit augue ac sem consequat, at mollis magna pharetra. Donec at congue mi, nec suscipit justo. Vivamus tincidunt arcu sed bibendum dignissim. Duis commodo luctus felis sit amet venenatis. Duis quis quam a elit fringilla interdum. Phasellus sed arcu rutrum, cursus nisl at, cursus nisi. Morbi rutrum augue ut nibh hendrerit, eu accumsan turpis sollicitudin. Duis tincidunt tellus eget odio placerat, in lobortis enim lobortis.</p>

									<p>Ut vitae tincidunt nunc, id bibendum eros. Maecenas facilisis porttitor vehicula. Quisque commodo pellentesque felis. Duis quis nibh ipsum. Nulla gravida, neque a aliquam hendrerit, libero nisl pretium nibh, quis pharetra arcu nulla ut dui. Nunc leo dui, elementum vel placerat non, ultricies sed dui. Donec semper odio aliquam ante vulputate tempus sit amet ac velit. Aliquam feugiat urna a libero fermentum pharetra.</p>

									<p>Donec laoreet erat ut sapien accumsan porttitor. In rutrum mi eget diam imperdiet, non porttitor velit rhoncus. Cras rhoncus odio elit. Praesent semper orci orci, non iaculis massa viverra et. Mauris dolor metus, interdum in scelerisque ac, fermentum at odio. Nullam rutrum faucibus mi, et fringilla metus fringilla eget. Fusce porttitor lorem a hendrerit consequat. In non orci luctus, euismod sem quis, faucibus libero. Nullam vestibulum, augue ut aliquet laoreet, purus velit tempor tellus, eget suscipit risus nisl suscipit dui. Aliquam diam nisi, condimentum eu est sed, ultricies egestas turpis.</p>

									<p>Nunc tempus nisi a elit ornare commodo. Ut lacinia libero sed eros molestie mollis. Etiam bibendum rhoncus nisi sit amet sollicitudin. Donec vulputate a sapien eget euismod. Donec mi enim, gravida eget euismod non, molestie a metus. Suspendisse ac arcu venenatis, sollicitudin libero non, feugiat lorem. Nunc vel justo id risus faucibus volutpat nec in felis. Morbi malesuada non tellus vel rhoncus. Vestibulum quam turpis, suscipit id lacinia eget, tristique posuere tellus. Etiam id gravida risus. Proin ut odio at dui accumsan vehicula.</p>

									<p>Pellentesque interdum erat ut odio commodo eleifend. Etiam arcu lectus, tristique in tellus quis, vulputate vehicula arcu. Proin eu orci consequat, adipiscing lorem dignissim, viverra nulla. Nunc venenatis mi vitae arcu pretium, bibendum semper turpis congue. Mauris in lacus ut elit vestibulum sagittis. Curabitur porta, orci lacinia congue dapibus, sem velit tincidunt enim, nec dictum eros mauris ut dui. Sed tristique malesuada ante, et commodo arcu molestie scelerisque. Nulla augue nunc, laoreet a magna sit amet, dapibus gravida neque. Duis mattis, ligula id fermentum hendrerit, arcu ante sodales est, et mattis massa tortor ac ante. Cras nibh lorem, dignissim sed iaculis id, viverra mollis libero. Fusce sed pellentesque lorem.</p>

									<p>Aliquam molestie nulla ac augue convallis, nec feugiat quam tincidunt. Maecenas turpis erat, bibendum sed arcu in, bibendum ultricies magna. Quisque in tellus sed justo placerat faucibus quis eu neque. Sed non semper nisl. Vestibulum vel felis eget elit adipiscing laoreet. Nam rhoncus feugiat mauris nec dignissim. Nulla eu lorem enim. Nam sagittis erat vitae est gravida commodo. Mauris vitae turpis sed enim semper suscipit nec sit amet libero. Nunc at neque hendrerit, blandit mauris in, consequat lacus. Nullam vel elit sit amet tellus tristique condimentum. Donec elit elit, condimentum sed dolor ut, euismod pharetra est. Pellentesque ultrices nisl nisi, ut adipiscing eros vulputate non. Proin in ultrices arcu, fermentum eleifend turpis. Aenean lacinia turpis eget ullamcorper gravida.</p>'
		),
		
		'Chapter_3' => (object)Array(
					'ID' => '3',
					'post_title' => 'Chapter Three',
					'post_name' => 'chapter-three',
					'post_content' => '<div class="pubml-chapter-ornament"></div>
									<p class="pubml-section-title">Chapter Three</p>
									<p class="pubml-subtitle">Unregistered Preview</p>
									<p class="noIndent"><span class="pubml-dropcaps">P</span><span class="pubml-smallcaps">lease register</span> your PubML Publishing tools plugin to enjoy a full preview of your books. If you`re still evaluating PubML, this preview will display your custom ornaments and text styles but not your custom content.</p><div class="pubml-separator-ornament"></div><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent vitae eros a quam porttitor vestibulum. Morbi sit amet orci id elit suscipit bibendum. Suspendisse lacinia ultricies posuere. Donec ornare tortor bibendum bibendum facilisis. Vivamus in suscipit est. Mauris vel accumsan lorem, et blandit sapien. Nullam velit lectus, tincidunt et mollis nec, ultricies in elit. Quisque eu justo nunc. In adipiscing odio arcu, vitae adipiscing nisl porttitor at. Quisque eget gravida lectus. Ut tristique nisl et nibh eleifend fringilla a vitae justo. Quisque suscipit dapibus ante. In ultricies mauris augue, eu malesuada justo tincidunt vitae. Ut diam elit, mollis vitae auctor sed, tristique nec purus. Praesent consectetur egestas turpis, nec aliquam justo adipiscing quis. Aenean pulvinar leo et auctor lacinia.</p>
									
									<p>Donec eu fringilla nulla. Nunc eget elit id augue eleifend condimentum porttitor id eros. Sed pellentesque convallis magna nec vulputate. Quisque quam est, mollis consequat velit eget, laoreet fringilla odio. Aliquam euismod, quam sit amet dignissim placerat, lorem erat varius nunc, sit amet lobortis sapien lacus molestie lorem. Nunc eleifend velit lorem, ut tempus arcu dapibus a. Curabitur et luctus lectus, sed lacinia tellus. Ut egestas vel est ac iaculis. Pellentesque viverra metus eget arcu venenatis, at sagittis nulla rhoncus. In pharetra ornare purus, ut pharetra augue blandit in. Maecenas auctor neque id tellus venenatis sollicitudin. Etiam rhoncus sapien ut nisl eleifend gravida. Etiam nibh arcu, elementum nec tincidunt at, adipiscing ac est.</p>

									<p>Vivamus lacus ipsum, vestibulum et vehicula scelerisque, semper id risus. Morbi elit neque, porta sed condimentum sed, mattis at ante. Etiam cursus est sit amet rhoncus sodales. Fusce hendrerit augue ac sem consequat, at mollis magna pharetra. Donec at congue mi, nec suscipit justo. Vivamus tincidunt arcu sed bibendum dignissim. Duis commodo luctus felis sit amet venenatis. Duis quis quam a elit fringilla interdum. Phasellus sed arcu rutrum, cursus nisl at, cursus nisi. Morbi rutrum augue ut nibh hendrerit, eu accumsan turpis sollicitudin. Duis tincidunt tellus eget odio placerat, in lobortis enim lobortis.</p>

									<p>Ut vitae tincidunt nunc, id bibendum eros. Maecenas facilisis porttitor vehicula. Quisque commodo pellentesque felis. Duis quis nibh ipsum. Nulla gravida, neque a aliquam hendrerit, libero nisl pretium nibh, quis pharetra arcu nulla ut dui. Nunc leo dui, elementum vel placerat non, ultricies sed dui. Donec semper odio aliquam ante vulputate tempus sit amet ac velit. Aliquam feugiat urna a libero fermentum pharetra.</p>

									<p>Donec laoreet erat ut sapien accumsan porttitor. In rutrum mi eget diam imperdiet, non porttitor velit rhoncus. Cras rhoncus odio elit. Praesent semper orci orci, non iaculis massa viverra et. Mauris dolor metus, interdum in scelerisque ac, fermentum at odio. Nullam rutrum faucibus mi, et fringilla metus fringilla eget. Fusce porttitor lorem a hendrerit consequat. In non orci luctus, euismod sem quis, faucibus libero. Nullam vestibulum, augue ut aliquet laoreet, purus velit tempor tellus, eget suscipit risus nisl suscipit dui. Aliquam diam nisi, condimentum eu est sed, ultricies egestas turpis.</p>

									<p>Nunc tempus nisi a elit ornare commodo. Ut lacinia libero sed eros molestie mollis. Etiam bibendum rhoncus nisi sit amet sollicitudin. Donec vulputate a sapien eget euismod. Donec mi enim, gravida eget euismod non, molestie a metus. Suspendisse ac arcu venenatis, sollicitudin libero non, feugiat lorem. Nunc vel justo id risus faucibus volutpat nec in felis. Morbi malesuada non tellus vel rhoncus. Vestibulum quam turpis, suscipit id lacinia eget, tristique posuere tellus. Etiam id gravida risus. Proin ut odio at dui accumsan vehicula.</p>

									<p>Pellentesque interdum erat ut odio commodo eleifend. Etiam arcu lectus, tristique in tellus quis, vulputate vehicula arcu. Proin eu orci consequat, adipiscing lorem dignissim, viverra nulla. Nunc venenatis mi vitae arcu pretium, bibendum semper turpis congue. Mauris in lacus ut elit vestibulum sagittis. Curabitur porta, orci lacinia congue dapibus, sem velit tincidunt enim, nec dictum eros mauris ut dui. Sed tristique malesuada ante, et commodo arcu molestie scelerisque. Nulla augue nunc, laoreet a magna sit amet, dapibus gravida neque. Duis mattis, ligula id fermentum hendrerit, arcu ante sodales est, et mattis massa tortor ac ante. Cras nibh lorem, dignissim sed iaculis id, viverra mollis libero. Fusce sed pellentesque lorem.</p>

									<p>Aliquam molestie nulla ac augue convallis, nec feugiat quam tincidunt. Maecenas turpis erat, bibendum sed arcu in, bibendum ultricies magna. Quisque in tellus sed justo placerat faucibus quis eu neque. Sed non semper nisl. Vestibulum vel felis eget elit adipiscing laoreet. Nam rhoncus feugiat mauris nec dignissim. Nulla eu lorem enim. Nam sagittis erat vitae est gravida commodo. Mauris vitae turpis sed enim semper suscipit nec sit amet libero. Nunc at neque hendrerit, blandit mauris in, consequat lacus. Nullam vel elit sit amet tellus tristique condimentum. Donec elit elit, condimentum sed dolor ut, euismod pharetra est. Pellentesque ultrices nisl nisi, ut adipiscing eros vulputate non. Proin in ultrices arcu, fermentum eleifend turpis. Aenean lacinia turpis eget ullamcorper gravida.</p>'
		),
		
	);
		return $chapters_array;
		
	}
	
/*
	Deafult Fonts
*/
function pubml_styles_default_fonts($key=''){
	$pubml_default_fonts = array(
		'1' => array (
				'link' => '',
				'family' => '',
				'fallback' => 'Georgia, serif',
				'font_type' => '1',
				'font_delete' => 'false',
			 ),
		'2' => array (
				'link' => '',
				'family' => '',
				'fallback' => 'Impact, Charcoal, sans-serif',
				'font_type' => '1',
				'font_delete' => 'false',
			),
		'3' => array (
				'link' => '<link href=\'http://fonts.googleapis.com/css?family=Alegreya:400,400italic,700,700italic\' rel=\'stylesheet\' type=\'text/css\'>',
				'family' => 'font-family: \'Alegreya\', serif;',
				'fallback' => 'Georgia, serif',
				'font_type' => NULL,
				'font_delete' => 'false',
			),
	    '4' => array (
				'link' => '<link href=\'http://fonts.googleapis.com/css?family=Crimson+Text:400,400italic,600,600italic\' rel=\'stylesheet\' type=\'text/css\'>',
				'family' => 'font-family: \'Crimson Text\', serif;',
				'fallback' => 'Georgia, serif',
				'font_type' => NULL,
				'font_delete' => 'false',
			),
		'5' => array (
				'link' => '<link href=\'http://fonts.googleapis.com/css?family=Old+Standard+TT:400,400italic,700\' rel=\'stylesheet\' type=\'text/css\'>',
				'family' => 'font-family: \'Old Standard TT\', serif;',
				'fallback' => 'Georgia, serif',
				'font_type' => NULL,
				'font_delete' => 'false',
			),
		'6' => array (
				'link' => '',
				'family' => '',
				'fallback' => 'Tahoma, Geneva, sans-serif',
				'font_type' => '1',
				'font_delete' => 'false',
			 ),
		'7'=> array (
				'link' => '',
				'family' => '',
				'fallback' => '\'Comic Sans MS\', cursive, sans-serif',
				'font_type' => '1',
				'font_delete' => 'false',
			 ),
		'8' => array (
				'link' => '',
				'family' => '',
				'fallback' => '\'Courier New\', Courier, monospace',
				'font_type' => '1',
				'font_delete' => 'false',
			 ),
			
		);
		
		if ($key !=  '') {
			return $pubml_default_fonts[$key];	
		}else {
			return $pubml_default_fonts;
		}
		
	}