/**

This file is part of <PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

The CONTENT found in the following directories and files: 

   -footnotes directory
   -sections directory
   -scripts/pubml_tabs.js 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

(function($){
    $.fn.curlies = function( itemQuery ) {
        function smarten(text) {
            return text
                /* opening singles */
                .replace(/(^|[-\u2014\s(\["])'/g, "$1\u2018")
 
                /* closing singles & apostrophes */
                .replace(/'/g, "\u2019")
 
                /* opening doubles */
                .replace(/(^|[-\u2014/\[(\u2018\s])"/g, "$1\u201c")
 
                /* closing doubles */
                .replace(/"/g, "\u201d")
 
                /* em-dashes */
                .replace(/--/g, "\u2014");
        };
 
        return this.each(function(){
            var $this = $(this);
            var $children = $this.children();
 
            if ($children.length) {
                $children.each(function(){
                    $(this).curlies();
                });
            } else {
                $this.text( smarten( $this.text() ) );
            }
        });
    };
})(jQuery);

 function getUrlVars() {
        var vars = {};
        var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
            vars[key] = value;
        });
        return vars;
} 

$(document).ready(function() {

	var leading = '';
	var line_height = '';
	var line_height_num = '';
	var media_href = '';
	var foot_href = '';
	var fonttype = '';	
	
	/* WEBSITE BACKGROUND */
	$("#bg1").click( function(){
		$("body").removeClass("topbg2").addClass("topbg1");
		var bg = 'topbg1'; 	cookievalue= bg+';';
		document.cookie="bg=" + cookievalue;	// setting into cookie
		getColumnCount();
		updatePageNumber();
	});
	$("#bg2").click( function(){				
		$("body").removeClass("topbg1").addClass("topbg2");
		var bg = 'topbg2'; 	cookievalue= bg+';';
		document.cookie="bg=" + cookievalue;	// setting into cookie	
		getColumnCount();
		updatePageNumber();	
	});
	
	/* PAGE BACKGROUND */
	$("#pbg1").click( function(){				  
		$(".book").removeClass("toppbg2").addClass("toppbg1");
		var pbg = 'toppbg1';	cookievalue= pbg+';';
		document.cookie="pbg=" + cookievalue;	// setting into cookie
		getColumnCount();
		updatePageNumber();
	});
	$("#pbg2").click( function(){
		$(".book").removeClass("toppbg1").addClass("toppbg2");
		var pbg = 'toppbg2'; cookievalue= pbg+';';
		document.cookie="pbg=" + cookievalue;	// setting into cookie		
		getColumnCount();
		updatePageNumber();	
	});
	
	/* TEXT JUSTIFICATION */
	$("#fullJustified").click( function(){				 
		$("#columntext p").removeClass("leftJustified").addClass("fullJustified");
		var align = 'fullJustified'; cookievalue= align+';';
		document.cookie="aln=" + cookievalue;	// setting into cookie			  
		getColumnCount();
		updatePageNumber();
	});			
	$("#leftJustified").click( function(){				 
		$("#columntext p").removeClass("fullJustified").addClass("leftJustified");
		var align = 'leftJustified'; cookievalue = align+';';
		document.cookie="aln=" + cookievalue;	// setting into cookie		  
		getColumnCount();
		updatePageNumber();
	});
	
	
	/* HYPERLINKS */
	$("#foothyper").click( function(){
		if ($('#foothyper').is(':checked')) {					   
			$(".footnote").removeClass("showFootnoteLinks").addClass("hideFootnoteLinks");
			var foothc = 'hideFootnoteLinks'; cookievalue= foothc+';';
			document.cookie="fnt=" + cookievalue; // setting into cookie						
		} else {
			$(".footnote").removeClass("hideFootnoteLinks").addClass("showFootnoteLinks");
			var foothc = 'showFootnoteLinks'; 	cookievalue= foothc+';';
			document.cookie="fnt=" + cookievalue;	// setting into cookie
		}
		getColumnCount();
		updatePageNumber();  
	});			
	$("#mediahyper").click( function(){
		if ($('#mediahyper').is(':checked')) {											
			$(".media").removeClass("showMediaLinks").addClass("hideMediaLinks");
			var mediac = 'hideMediaLinks';
			cookievalue= mediac+';';
			document.cookie="med=" + cookievalue;	// setting into cookie
		} else {						
			$(".media").removeClass("hideMediaLinks").addClass("showMediaLinks");
			var mediac = 'showMediaLinks';	cookievalue= mediac+';';
			document.cookie="med=" + cookievalue; // setting into cookie
		}
		getColumnCount();
		updatePageNumber();  
	});
	/* HYPERLINKS */
	
	/* FONTS */
	$("#smallf").click( function(){		
		$("#columntext p").css("font-size",'1.8rem');
		$("#columntext p").css("line-height",'2.55rem');
		$("#columntext p.pubml-section-title").css({"font-size":'2.8rem',"line-height":'3.8rem'});
		$("#columntext p.pubml-subtitle").css({"font-size":'2.2rem',"line-height":'3rem'});
		$(".pubml-dropcaps").css({"font-size":'6.15rem', "line-height":'5rem'}); 
		 /* set corresponding lineheights */
			 $("#leading1").val('2.4');
			 $("#leading2").val('2.55');
			 $("#leading3").val('2.71');
		 /* set corresponding lineheights */
		 // setting into cookie
				   var fontsz = '1.8rem';
				   cookievalue= fontsz+';';
				   document.cookie="fs=" + cookievalue;					   
			   	   var lineh = '2.55rem';
				   cookievalue= lineh+';';
				   document.cookie="lh=" + cookievalue;	
			   //alert("Setting Cookies : " + "bookbg=" + cookievalue );
				   var dfontsz = '6.15rem';
				   cookievalue= dfontsz+';';
				   document.cookie="dfs=" + cookievalue;
				   var dlineheight = '5rem';
				   cookievalue= dlineheight+';';
				   document.cookie="dlh=" + cookievalue;		  
			   //alert("Setting Cookies : " + "bookbg=" + cookievalue );
				
				// Set Heading Font-size in cookies 
					var headfontsze = 2.8;
					cookievalue= headfontsze+'rem;';
					document.cookie="hfs=" + cookievalue;
					var headlineheight = headfontsze + 1;
					cookievalue= headlineheight+'rem;';
					document.cookie="hlh=" + cookievalue;	
				
				// Set Sub-Heading Font-size in cookies 
					var subheadfontsze = 2.2;
					cookievalue= subheadfontsze+'rem;';
					document.cookie="sbfs=" + cookievalue;
					var subheadlineheight = subheadfontsze + 0.8;
					subheadlineheighta = Math.round(subheadlineheight*100)/100;
					cookievalue= subheadlineheighta+'rem;';
					document.cookie="sblh=" + cookievalue;	
				
				// Set Small Print Font-size and line-height in cookies 
					var smallptfontsze = 1;
					cookievalue= smallptfontsze+'rem;';
					document.cookie="smfs=" + cookievalue;
					var smallptlineheight = smallptfontsze + 0.4;
					smallptlineheight = Math.round(smallptlineheight*100)/100;
					cookievalue= smallptlineheight+'rem;';
					document.cookie="smlh=" + cookievalue;	
					
			// setting into cookie			  
		getColumnCount();
		updatePageNumber();//adjusts number ofpages/columns
	});
	
	$("#standf").click( function(){
		$("#columntext p").css("font-size",'2.1rem');
		$("#columntext p").css("line-height",'2.7rem');
		$("#columntext p.pubml-section-title").css({"font-size":'3.3rem',"line-height":'4.3rem'});
		$("#columntext p.pubml-subtitle").css({"font-size":'2.6rem',"line-height":'3.4rem'});
		$(".pubml-dropcaps").css({"font-size":'6.9rem', "line-height":'5.3rem'});
		 
		 /* set corresponding lineheights */
			$("#leading1").val('2.54');
			$("#leading2").val('2.7');
			$("#leading3").val('3.13');
		 /* set corresponding lineheights */
		 // setting into cookie
				   var fontsz = '2.1rem';
				   cookievalue= fontsz+';';
				   document.cookie="fs=" + cookievalue;	
			   //alert("Setting Cookies : " + "bookbg=" + cookievalue );
				   var lineh = '2.7rem';
				   cookievalue= lineh+';';
				   document.cookie="lh=" + cookievalue;	
			   //alert("Setting Cookies : " + "bookbg=" + cookievalue );
				   var dfontsz = '6.9rem';
				   cookievalue= dfontsz+';';
				   document.cookie="dfs=" + cookievalue;
				   var dlineheight = '5.3rem';
				   cookievalue= dlineheight+';';
				   document.cookie="dlh=" + cookievalue;
			   //alert("Setting Cookies : " + "bookbg=" + cookievalue );
				// Set Heading Font-size in cookies 
					var headfontsze = 3.3;
					cookievalue= headfontsze+'rem;';
					document.cookie="hfs=" + cookievalue;	
					var headlineheight = headfontsze + 1;
					cookievalue= headlineheight+'rem;';
					document.cookie="hlh=" + cookievalue;
				
				// Set Sub-Heading Font-size in cookies 
					var subheadfontsze = 2.6;
					cookievalue= subheadfontsze+'rem;';
					document.cookie="sbfs=" + cookievalue;	
					var subheadlineheight = subheadfontsze + 0.8;
					subheadlineheighta = Math.round(subheadlineheight*100)/100;
					cookievalue= subheadlineheighta+'rem;';
					document.cookie="sblh=" + cookievalue;	
					
				// Set Small Print Font-size and line-height in cookies 
					var smallptfontsze = 1.1;
					cookievalue= smallptfontsze+'rem;';
					document.cookie="smfs=" + cookievalue;
					var smallptlineheight = smallptfontsze + 0.3;
					smallptlineheight = Math.round(smallptlineheight*100)/100;
					cookievalue= smallptlineheight+'rem;';
					document.cookie="smlh=" + cookievalue;		
			   
		// setting into cookie
		getColumnCount();
		updatePageNumber();//adjusts number ofpages/columns
	});
	
	$("#largef").click( function(){
		$("#columntext p").css("font-size",'2.5rem');
		$("#columntext p").css("line-height",'3.65rem');
		$("#columntext p.pubml-section-title").css({"font-size":'3.8rem',"line-height":'4.8rem'});
		$("#columntext p.pubml-subtitle").css({"font-size":'3rem',"line-height":'3.8rem'});
		$(".pubml-dropcaps").css({"font-size":'8.65rem', "line-height":'7.2rem'});
		 /* set corresponding lineheights */
			$("#leading1").val('3.36');
			$("#leading2").val('3.65');
			$("#leading3").val('4');
		 /* set corresponding lineheights */
		 // setting into cookie
				   var fontsz = '2.5rem';
				   cookievalue= fontsz+';';
				   document.cookie="fs=" + cookievalue;	
			   //alert("Setting Cookies : " + "bookbg=" + cookievalue );
				   var lineh = '3.65rem';
				   cookievalue= lineh+';';
				   document.cookie="lh=" + cookievalue;	
			   //alert("Setting Cookies : " + "bookbg=" + cookievalue );
				   var dfontsz = '8.65rem'; 
				   cookievalue= dfontsz+';'; 
				   document.cookie="dfs=" + cookievalue;	
				   var dlineheight = '7.2rem';
				   cookievalue= dlineheight+';';
				   document.cookie="dlh=" + cookievalue;	
			   //alert("Setting Cookies : " + "bookbg=" + cookievalue );
				// Set Heading Font-size in cookies 
					var headfontsze = 3.8;
					cookievalue= headfontsze+'rem;';
					document.cookie="hfs=" + cookievalue;	
					var headlineheight = headfontsze + 1;
					cookievalue= headlineheight+'rem;';
					document.cookie="hlh=" + cookievalue;	
				
				// Set Sub-Heading Font-size in cookies 
					var subheadfontsze = 3;
					cookievalue= subheadfontsze+'rem;';
					document.cookie="sbfs=" + cookievalue;
					var subheadlineheight = subheadfontsze + 0.8;
					subheadlineheighta = Math.round(subheadlineheight*100)/100;
					cookievalue= subheadlineheighta+'rem;';
					document.cookie="sblh=" + cookievalue;	
					
				// Set Small Print Font-size and line-height in cookies 
					var smallptfontsze = 1.2;
					cookievalue= smallptfontsze+'rem;';
					document.cookie="smfs=" + cookievalue;
					var smallptlineheight = smallptfontsze + 0.3;
					smallptlineheight = Math.round(smallptlineheight*100)/100;
					cookievalue= smallptlineheight+'rem;';
					document.cookie="smlh=" + cookievalue;	
					
		  // setting into cookie
		getColumnCount();
		updatePageNumber();//adjusts number ofpages/columns
	});
	/* FONTS */
	
	/* TYPE FACE */
	$("#typefaceid").change(function() {
    	//alert($(this).val());
    	$("#columntext p").css("font-family", $(this).val());
		$("#columntext h1").css("font-family", $(this).val());
		$("#columntext h2").css("font-family", $(this).val());
		$("#columntext .smallcaps").css("font-family", $(this).val());
		$("#runningHead").css("font-family",$(this).val());
		$(".dropCap").css("font-family", $(this).val());
		$("#typefaceid").val($(this).val());
		// setting into cookie
				   var fontf = $(this).val();
				   //alert(fontf);
				   cookievalue= fontf+';';
				   document.cookie="ff=" + cookievalue;	
			   //alert("Setting Cookies : " + "bookbg=" + cookievalue );				  
		// setting into cookie
		getColumnCount();
		updatePageNumber();//adjusts number ofpages/columns
	});
	/* TYPE FACE */
	
	/* LINE HEIGHTS */
    $("#line-height-1").click( function(){
		 var current_line_height = $("#leading1").val();
		 var dropcap_lineheight  = 2 * parseFloat(current_line_height);
		 //alert(dropcap_lineheight);		
		 $("#columntext p").css("line-height",current_line_height+'rem');
		 $(".dropCap").css("line-height",dropcap_lineheight+'rem');	
		// setting into cookie				  
				   var lineh = current_line_height;
				   cookievalue= lineh+'rem;';
				   document.cookie="lh=" + cookievalue;	
			   //alert("Setting Cookies : " + "bookbg=" + cookievalue );
				   var dlineh = dropcap_lineheight;
				   cookievalue= dlineh+';';
				   document.cookie="dlh=" + cookievalue;	
			   //alert("Setting Cookies : " + "bookbg=" + cookievalue );
		// setting into cookie	
		getColumnCount();
		updatePageNumber();//adjusts number ofpages/columns
    });  
	
    $("#line-height-2").click( function(){
		 var current_line_height = $("#leading2").val();
		 var dropcap_lineheight  = 2 * parseFloat(current_line_height);
		 //alert(dropcap_lineheight);		
		 $("#columntext p").css("line-height",current_line_height+'rem');
		 $(".dropCap").css("line-height",dropcap_lineheight+'rem');	
		 // setting into cookie				  
				   var lineh = current_line_height;
				   cookievalue= lineh+'rem;';
				   document.cookie="lh=" + cookievalue;	
			   //alert("Setting Cookies : " + "bookbg=" + cookievalue );
				   var dlineh = dropcap_lineheight;
				   cookievalue= dlineh+'rem;';
				   document.cookie="dlh=" + cookievalue;	
			   //alert("Setting Cookies : " + "bookbg=" + cookievalue );
		// setting into cookie	
		getColumnCount();
		updatePageNumber();//adjusts number ofpages/columns
    });
	
    $("#line-height-3").click( function(){
		var current_line_height = $("#leading3").val();
		var dropcap_lineheight  = 2 * parseFloat(current_line_height);
		//alert(dropcap_lineheight);		
		$("#columntext p").css("line-height",current_line_height+'rem');
		$(".dropCap").css("line-height",dropcap_lineheight+'rem');	
			// setting into cookie				  
			var lineh = current_line_height;
			cookievalue= lineh+'rem;';
			document.cookie="lh=" + cookievalue;	
			//alert("Setting Cookies : " + "bookbg=" + cookievalue );
			var dlineh = dropcap_lineheight;
			cookievalue= dlineh+'rem;';
			document.cookie="dlh=" + cookievalue;	
		
		// setting into cookie	
		getColumnCount();
		updatePageNumber();//adjusts number ofpages/columns
    });  	
	/* LINE HEIGHTS */
							
	/* IMPLEMENTING COOKIE SETTINGS */
	setTimeout(function() {
		getCookieSettings();
	}, 1000);			
	/* IMPLEMENTING COOKIE SETTINGS */
	
	/* FONT & LINE HEIGHT SETTING AT LAUNCH */
		$("#columntext p").css("font-size",'2.1rem');
		$("#columntext p").css("line-height",'2.7rem');
		$(".dropCap").css("line-height",'5.4rem');	
	/* FONT & LINE HEIGHT SETTING AT LAUNCH */
	
	setImagesToREM();

	if($(window).width()<500){
		$('#tabs').css('top','28px');
	}

	$('.mobileTabs .mobileTabTriger, .mobileTabs .mobileTabTitle').click(function(){
		var crt_pos = $('#tabs').css('left');
		$('#tabs').css('left','-500');
		if(crt_pos =='0px'){
			$('#tabs').css({'left':'-640px','top': '28px'});
		}else{
			$('#tabs').css({'left':'0px', 'top': '28px'});
		}
	});	
	
// Get the URL Parameter for the referer	
	$('.mobileTabs span#mobileTabClose').click(function(){
		var referer = getParameterByName('referer');
		if(typeof referer != 'undefined' && referer != '' ){
			window.location.href = referer;
		}
		
	});	
		
});	

// SET THE COOKIES AS PER SETTINGS DATA. 
function setCookiesSettings(){	
	    /* set corresponding lineheights and font-size of all paragraph */
		   var pubml_P_fontsize = '2.5rem';
		   cookievalue= pubml_P_fontsize+';';
		   document.cookie="pubml_P_fontsize=" + cookievalue;		   
		   var pubml_P_lnht = '3.65';
		   cookievalue= pubml_P_lnht+';';
		   document.cookie="pubml_P_lnht=" + cookievalue;	
	   
	   /* set corresponding lineheights and font-size of all paragraph */
	   
		   var pubml_heading_fontsize = $('#columntext p.pubml-section-title').css('font-size');
		   cookievalue= pubml_heading_fontsize+';';
		   document.cookie="pubml_heading_fontsize=" + cookievalue;		   
		   var pubml_heading_lnht = '3.65';
		   cookievalue= pubml_heading_lnht+';';
		   document.cookie="pubml_heading_lnht=" + cookievalue;	
	   
		  
} // SET THE COOKIES AS PER SETTINGS DATA. 

// SET THE IMAGES TO REM FOR SCALING. 
function setImagesToREM(){
	// Find the width attribute of each img tag and update the width and height in rem
	$("img").each(function( index, element ){ 
		var width_px ='', height_px = '';
		width_px = $( element ).attr('width'); // Get the width of image
		
		if(typeof width_px != 'undefined'){
			$(this).css('width',(width_px/10)+'rem');
		}
	});
}

// SET THE IMAGE WIDTH AND HEIGHT WHILE LOADING TO REM FOR SCALING. 
	function setImageWidthHeight(){	
		setTimeout( function(){
			$("#columntext img").each(function() {
				$(this).css({ 'min-height': $(this).height()})	;
			});
		},100);		
	}
	
// Get the URL Parameter for the referer	
	function getParameterByName(name) {
		name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
		var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),	results = regex.exec(location.search);
		return results == null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
	}	
	
// Function to set the settings parameter as per the passed data in the url.
function setByParameters(){

	var saved_fs		= 	getParameterByName('fs');	
	var saved_lh	 	=	getParameterByName('lh');
	var saved_txtjust 	= 	getParameterByName('aln')
	var saved_bookbg 	= 	getParameterByName('bg'); 
	var saved_pagebg 	= 	getParameterByName('pbg'); 
	var saved_footh 	= 	getParameterByName('fnt'); 
	var saved_mediah 	= 	getParameterByName('med');
	var saved_dfs	 	= 	getParameterByName('dfs');
	var saved_dlh	 	= 	getParameterByName('dlh');
	var saved_hfs	 	= 	getParameterByName('hfs');
	var saved_hlh	 	= 	getParameterByName('hlh');
	var saved_sbfs	 	= 	getParameterByName('sbfs');
	var saved_sblh	 	= 	getParameterByName('sblh');
	var saved_smfs	 	= 	getParameterByName('smfs');
	var saved_smlh	 	= 	getParameterByName('smlh');
	var saved_fontfam 	= 	getParameterByName('ff');
	
	// console.log(saved_fs +' <> '+saved_lh +' <> '+ saved_txtjust +' <> '+saved_bookbg +' <> '+saved_pagebg +' <> '+saved_footh +' <> '+saved_mediah +' <> '+saved_dfs +' <> '+saved_dlh +' <> '+saved_hfs +' <> '+saved_hlh +' <> '+saved_sbfs +' <> '+saved_sblh +' <> '+saved_smfs +' <> '+saved_smlh +' <> '+saved_fontfam );
	
	/* Font-Size of paragraph start */
	if(saved_fs!=''){
		$("#columntext p").css("font-size",saved_fs);
	}
	/* line-height of paragraph start */
	if(saved_lh!=''){
		$("#columntext p").css("line-height",saved_lh);
	}
	
	/* Font-Size of Dropcaps start */
	if( (typeof saved_dfs != 'undefined') || ( $.trim(saved_dfs) != '') ){
		$(".pubml-dropcaps").css("font-size" , saved_dfs); 
	}
	/* line-height of Dropcaps start */
	if( (typeof saved_dlh != 'undefined') || ( saved_dlh != '') ){
		$(".pubml-dropcaps").css("line-height" , saved_dlh); 
	}
	
	/* Font-Size of Heading start */
	if( (typeof saved_hfs != 'undefined') || ( saved_hfs != '') ){
		$("#columntext p.pubml-section-title").css("font-size",saved_hfs);
	}		
	/* line-height of Heading start */
	if( (typeof saved_hlh != 'undefined') || ( saved_hlh != '') ){
		$("#columntext p.pubml-section-title").css("line-height",saved_hlh);
	}	
	
	/* Font-Size of Sub-Heading start */
	if( (typeof saved_sbfs != 'undefined') || ( saved_sbfs != '') ){	
		$("#columntext p.pubml-subtitle").css("font-size",saved_sbfs);
	}		
	/* line-height of Sub-Heading start */
	if( (typeof saved_sblh != 'undefined') || ( saved_sblh != '') ){	
		$("#columntext p.pubml-subtitle").css("line-height",saved_sblh);
	}
	
	/* Font-Size and line-height for small print text start */
	if( (typeof saved_smfs != 'undefined') || ( saved_smfs != '') ){	
		$("#columntext p.pubml-small-print").css("font-size",saved_smfs);
	}		
	if( (typeof saved_smlh != 'undefined') || ( saved_smlh != '') ){	
		$("#columntext p.pubml-small-print").css("line-height",saved_smlh);
	}
	
	/* Font-Family of Sub-Heading start */
	if(saved_fontfam!=''){
		$("#columntext p").css("font-family", saved_fontfam);
		$("#columntext h1").css("font-family", saved_fontfam);
		$("#columntext h2").css("font-family", saved_fontfam);
		$("#columntext .smallcaps").css("font-family",saved_fontfam);
		$("#runningHead").css("font-family",saved_fontfam);
		$(".dropCap").css("font-family", saved_fontfam);
	}
	if(saved_txtjust!=''){
		if(saved_txtjust=='leftJustified'){
			 $("#columntext p").removeClass("fullJustified").addClass("leftJustified");
		}
		else if(saved_txtjust=='fullJustified'){
			$("#columntext p").removeClass("leftJustified").addClass("fullJustified");
		}
	}
	if(saved_bookbg!=''){
		if(saved_bookbg=='topbg2'){
			$("body").removeClass("topbg1").addClass("topbg2");
		}
		else if(saved_bookbg=='topbg1'){
			$("body").removeClass("topbg2").addClass("topbg1");
		}
	}
	if(saved_pagebg!=''){
		if(saved_pagebg=='toppbg2'){
			$(".book").removeClass("toppbg1").addClass("toppbg2");
		}
		else if(saved_pagebg=='toppbg1'){
			$(".book").removeClass("toppbg2").addClass("toppbg1");
		}
	}
	if(saved_footh!=''){
		if(saved_footh=='hideFootnoteLinks'){
			$(".footnote").removeClass("showFootnoteLinks").addClass("hideFootnoteLinks");
		}
		else if(saved_footh=='undefined'){
			$(".footnote").removeClass("hideFootnoteLinks").addClass("showFootnoteLinks");
		}
	}
	if(saved_mediah!=''){
		if(saved_mediah=='hideMediaLinks'){
			$(".media").removeClass("showMediaLinks").addClass("hideMediaLinks");
		}
		else if(saved_mediah=='undefined'){
			$(".media").removeClass("hideMediaLinks").addClass("showMediaLinks");
		}
	}
}			