/**

This file is part of <PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

The CONTENT found in the following directories and files: 

   -footnotes directory
   -sections directory
   -scripts/pubml_tabs.js 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


// JavaScript Document

//-----GLOBAL VARS adjust to match css or turn n testing module)--------------------------------------

var columnWidth = 300;//width of a text column - must match css
var columnGap = 300;//gap between text columns - must match css
var testing=false;//true to display global vars, #false to hide test div
var transitionSpeed = 200;//speed of page transition in ms

//-------PRIVATE VARS used by script to manage data (don't touch)------------------------------
var numberOfPages = 0;//number of pages in the loaded section
var currentPage = 1;//current page within a chapter (pages are columns)
var currentChapterIndex = 0;//track the array index of the chapter currently being displayed (5 if testing with 01.html)
var tocData = [];//stores the data from toc.json in a global array for easy access
var columntextOffset;//stores the location of the #columntext div on doc.ready
var loadingNext;//flags whether section to be loaded is next or prev section 
var urlhash = "";//stores the params appended to the url after the #
var bookMarkedLoaded = false;//has bookmark been loaded? stop future reading of urlhash after first load
var bookMarkedPage = 1;//store number of page specified in url hash
var textWidth;//holds total width of loaded #columntext
var pageTransitionInProgress = false;
var totalColumnWidth = columnWidth + columnGap;

$(document).ready(function (){	
	// Getting the width and Height of the PubML to adjust pagination
			var isiPhone = navigator.userAgent.toLowerCase().indexOf("iphone");
			if(isiPhone > -1){
				var referer = getParameterByName('referer');				
				if(typeof referer != 'undefined' && referer != '' ){		
					jQuery(".cbutton").show();
				}				
				jQuery('body').css("min-height",$(window).height());
				window.scrollTo(0, 1);
			}

			var pubMLWindowWidth = $(window).width();
			var pubMLBookWidth = $('#columntext').width();
			var pubMLcolWidth = $('#cover').width();
			columnWidth =  pubMLBookWidth ; 
			columnGap = ((pubMLcolWidth - pubMLBookWidth)*3);	
			totalColumnWidth = pubMLBookWidth + columnGap;
	
	$('#columntext').css({"-webkit-column-gap": columnGap , "-moz-column-gap": columnGap, "-ms-column-gap": columnGap, "column-gap": columnGap, "-moz-column-width": columnWidth, "-webkit-column-width": columnWidth, "-ms-column-width": columnWidth, "column-width": columnWidth});

	jQuery(".cbutton").click(function(){
		history.go(-1);
	});

	jQuery("#columntext").on('click','a.footnote',function(){
		var footnote_id = jQuery(this).attr("rel");
		getFootnote(footnote_id);
	});	
	
	
	jQuery("#columntext").on('click','a.media',function(){
		var media_id = jQuery(this).attr("rel");
		getMedia(media_id);
	});	

});

// Set the variable at run time
$(window).resize(function() {
	// Getting the width and Height of the PubML to adjust pagination
	var pubMLWindowWidth = $(window).width();
	var pubMLBookWidth = $('#columntext').width();
	var pubMLcolWidth = $('#cover').width();
	columnWidth =  pubMLBookWidth ; 
	columnGap = ((pubMLcolWidth - pubMLBookWidth)*3);	
	totalColumnWidth = pubMLBookWidth + columnGap;
	$('#columntext').css({"-webkit-column-gap": columnGap , "-moz-column-gap": columnGap, "-ms-column-gap": columnGap, "column-gap": columnGap, "-moz-column-width": columnWidth, "-webkit-column-width": columnWidth, "-ms-column-width": columnWidth, "column-width": columnWidth});
		
});

//----FOR TESTING, DISPLAY GLOBAL VARS IN A DIV ON THE PAGE-------------------------------------------
function showGlobals() {
	if(testing) {
		var testData = ("current index:" + currentChapterIndex + "<br />");
		testData += ("current page:" + currentPage+ "<br />");
		testData += ("total pages:" + numberOfPages+ "<br />");
		testData += ("columntext pos: ( " + parseInt(columntextOffset.left) + "," + parseInt(columntextOffset.top) + " )");
		//alert(testData);
		$("#test").html(testData);
	}
}

//---FETCH TABLE OF CONTENTS FROM TOC JSON FILE------------------------------------------------------
/*$.getJSON( "data/toc.json", function( json ) {
	tocData = json.contents;	 
	//if chapterIndex == 0 and there is no hash to indicate a bookmark at first load	
	if((currentChapterIndex == 0) & (urlhash.indexOf("=") == -1 )){
		loadContentCover();/* Call for cover on first load if there is no url hash */			
/*	} else {
		fetchBookMark();
	}
});*/

$.ajax({
    url: "data/toc.json",
    dataType: "json",
    mimeType: "application/json",
    
	success: function(json){
		tocData = json.contents;	 
		//if chapterIndex == 0 and there is no hash to indicate a bookmark at first load	
		if((currentChapterIndex == 0) & (urlhash.indexOf("=") == -1 )){
			loadContentCover();/* Call for cover on first load if there is no url hash */			
		} else {
			fetchBookMark();
		}
    } 
});

/* -----------  LOAD SECTION FROM CONTENTS PANEL --------------- */
function getSection(tocIndex){
	$(".prevPageArea").show();//show next/prev hot areas
	$(".nextPageArea").show();
	hideNavPanels()//hide any open tab panels
	currentChapterIndex = parseInt(tocIndex);//get section index from function call
	if(tocData[currentChapterIndex].type == 'cover'){
		loadContentCover();
	}
	if(tocData[currentChapterIndex].type == 'columntext'){
		loadingNext = true;//assume we're loading a "next" section so 
		//it will be positioned to display the first page
		loadContentColumntext();
	}
}

//---FETCH A SECTION & PAGE IF A HASH/BOOKMARK IS APPENDED TO THE URL ON LOAD-------------
//---this function is called if a hash is detected on document.ready
function fetchBookMark() {
	//parse the section index out of the url hash 
	currentChapterIndex = parseInt(urlhash.substring(2,urlhash.indexOf("&")));
	//parse the page number out of the url hash
	bookMarkedPage = parseInt(urlhash.substring(urlhash.indexOf("&")+3));
	loadBookmarkedSection();
}

//--LOAD JSON data into the array------------------------------------------------
function loadTOC() {
	//alert('initial call');
	setTimeout(function(){
		var tocContent="";
		for (var i=0; i < tocData.length; i++) {
			tocContent+=("<p class='" + tocData[i].css_class + "'><a href='javascript:void(0);' onclick='getSection(" + i + ")'>" + tocData[i].title + "</a></p>");
		}	
		$("#contentspanel").html(tocContent);		
	},1000);	
}	

//---LOAD NEXT SECTION - CALLED BY NEXT PAGE HOT AREA WHEN A SECTION IS AT ITS END--------------------
function loadNextSection() {
	$(".prevPageArea").show();//show next/prev hot areas
	$(".nextPageArea").show();
	currentChapterIndex++;//increment toc array index
	
	// Set the currentChapterIndex to 0 once reached the last page.
	if(currentChapterIndex >= tocData.length)
		currentChapterIndex = 0;
		
	if(tocData[currentChapterIndex].type == 'cover'){
		loadContentCover();
	}
	if(tocData[currentChapterIndex].type == 'columntext'){
		loadingNext = true;//tracks whether loading a next or prev section
		//so getTextWidth can position div at first or last colunn
		loadContentColumntext();
	}
	//showGlobals();	
	hideNavPanels();  // To Hide the Tabs
}

//---LOAD PREVIOUS SECTION - CALLED BY PREV PAGE HOT AREA WHEN A SECTION IS AT ITS BEGINNING--------------------
function loadPrevSection() {
	$(".prevPageArea").show();//show next/prev hot areas
	$(".nextPageArea").show();
	if(currentChapterIndex >= 0 ) {//don't load anything < 0
		currentChapterIndex --;//decrement toc array index
		if(tocData[currentChapterIndex].type == 'cover'){
			loadContentCover();
		}
		if(tocData[currentChapterIndex].type == 'columntext'){
			loadingNext = false;//tracks whether loaing a next or prev section
			//so getTExtWidth can position div at first or last colunn
			loadContentColumntext();
		}
	}
	hideNavPanels();  // To Hide the Tabs
} 

//---LOAD BOOKMARKED SECTION - DOES NOT INCREMENT OR DECREMENT SECTION INDEX - USES PARAMS FROM URL HASH
function loadBookmarkedSection() {
	$(".prevPageArea").show();//show next/prev hot areas
	$(".nextPageArea").show();
	if(tocData[currentChapterIndex].type == 'cover'){
		loadContentCover();
	}
	if(tocData[currentChapterIndex].type == 'columntext'){
		loadingNext = true;//assume we're starting at the beginning of a section
		//so getTextWidth can position div at first or last colunn
		loadContentColumntext();
	}
}

//---THIS LOADS CONTENT FROM TOC.JSON ENLISTED PAGES INTO APPROPRIATE DIV ONLY FOR COVER ---------------------------------------
function loadContentCover() {
	if(typeof tocData[currentChapterIndex] != 'undefined'){
		document.title = tocData[currentChapterIndex].title;
		$("#runningHead").text(tocData[currentChapterIndex].heading);
		var sectionURL = "sections/"+tocData[currentChapterIndex].url;	
		if (tocData[currentChapterIndex].type == "cover") {
			numberOfPages = 1;
			currentPage = 1;
			$("#cover").load(sectionURL,showCover);//<---CONTENT IS LOADING INTO DIV #cover
		}
	}	
}

//---HIDE/SHOW thE COVER DIV LOADED ABOVE THE #columntext DIV-------------------------------
		// #cover is the same size as #book but has no padding so images can display full-size
		function hideCover() {
			$("#cover").fadeOut(1000);//fade out the cover
		}
			
		function showCover() {
			$("#cover").fadeIn(1000);//fade in the cover
			$("#bookMarker").hide();
			if(currentChapterIndex == 0){
				$(".prevPageArea").hide();//show next/prev hot areas
			}
			updateURL();//changes the address in the browser address bar for bookmarking
		}

//---THIS LOADS TEXT/MEDIA CONTENT FROM TOC.JSON INTO #COLUMNTEXT DIV---------------------------------------
function loadContentColumntext() {
	numberOfPages = 1;
	currentPage = 1;
	document.title = tocData[currentChapterIndex].title;	
	$("#runningHead").text(tocData[currentChapterIndex].heading);
	var sectionURL = "sections/"+tocData[currentChapterIndex].url;
	if (tocData[currentChapterIndex].type == "columntext") {
		$("#columntext").load(sectionURL,getTextWidth);//<---CONTENT IS LOADING INTO DIV #columntext	
		//$("#columntext h1").css("margin-bottom","2.8rem");	
		hideCover();//hide the cover div in case it's showing
	}
	// alert('// TOP ::'+columntextOffset.top+'// LEFT ::'+columntextOffset.left); // ADDED TESTING
	// var calculated = columntextOffset.left - (textWidth-columnGap);// ADDED TESTING
	// alert('// CALCULATED LEFT ::'+calculated); // ADDED TESTING
}


//---MEASURE THE LOADED MULTICOLUMN TEXT AND CALCUATE HOW MANY COLUMNS/PAGES THERE ARE-------------
//this retrieves the width of the loaded text after the ajax load completes
//you can't retrieve the width of an {overflow:hidden} div so overflow is set to scroll
//in the css rule and then reset to visible in this script AFTER measuring the scrollbar


/*function getColumnCount() {
	$("#columntext").css("overflow-x",'scroll');//set  overflow-x  to  scroll
	//if you set overflow instead of overflow-x, the resulting vertical scrollbar takes 20px 
	//away from each column and screws up the measurement (now we are calculating pages correctly)
	textWidth  =  $("#columntext")[0].scrollWidth;//get  width  of  scrollbar
	$("#columntext").css("overflow-x",'visible');//set  overflow  to  visible
	//calculate  column/page  count
	numberOfPages  =  parseInt(textWidth  /  totalColumnWidth) + 1;
}
*/
	
function getColumnCount() {
	// add a div at the end of the text 
	$('#columntext').append('<div id="endmarker"></div>');
	//get its position to find out width of #columntext
	var endMarkerPosition = $('#endmarker').position().left;
	// add the width of the final column (because span will be at left side of column) 
	textWidth = endMarkerPosition + columnWidth;
	numberOfPages  =  parseInt(textWidth  /  totalColumnWidth) + 1;
	//just in case endmarker is pushed to next column
	if($('#endmarker').position().top == $('#columntext').position().top) {
		numberOfPages -= 1;
	}
	// remove added <div>
	$('#endmarker').remove();//div us 5px x 5px red and visible if not removed. Comment this line out for testing
}

function getCookieSettings() {
/* IMPLEMENTING COOKIE SETTINGS */
	//Get all the cookies pairs in an array
	var allcookies = document.cookie;	
	cookiearray  = allcookies.split(';');
	// console.log(cookiearray);
	// Now take key value pair out of this array
	for(var i=0; i<cookiearray.length; i++){
		name = cookiearray[i].split('=')[0];
		value = cookiearray[i].split('=')[1];
		//alert("Key is :" + name + "- and Value is : " + value);					
		// TEXT JUSTIFICATION
		if($.trim(name) == 'aln'){						
			var currenjust = value;
			//alert(currenbg);
			if(currenjust == 'fullJustified'){
				$("#columntext p").removeClass("leftJustified").addClass("fullJustified");
			}			
			if(currenjust == 'leftJustified'){
				$("#columntext p").removeClass("fullJustified").addClass("leftJustified");
			}	
		}
		// TEXT JUSTIFICATION
		// FOOTNOTES LINK
		if($.trim(name) == 'fnt'){						
			var currenfoot = value;
			//alert(currenbg);
			if(currenfoot == 'hideFootnoteLinks'){
				$(".footnote").removeClass("showFootnoteLinks").addClass("hideFootnoteLinks");
				$('#foothyper').attr('checked','checked');
			}			
			if(currenfoot == 'showFootnoteLinks'){
				$(".footnote").removeClass("hideFootnoteLinks").addClass("showFootnoteLinks");
			}	
		}
		// FOOTNOTES LINK
		// MEDIA LINK
		if($.trim(name) == 'med'){						
			var currenmedia = value;
			//alert(currenbg);
			if(currenmedia == 'hideMediaLinks'){
				$(".media").removeClass("showMediaLinks").addClass("hideMediaLinks");
				$('#mediahyper').attr('checked','checked');
			}			
			if(currenmedia == 'showMediaLinks'){
				$(".media").removeClass("hideMediaLinks").addClass("showMediaLinks");
			}	
		}
		// MEDIA LINK
		// FONT SIZES
		if($.trim(name) == 'fs'){						
			var currenfontsze = value;
			//alert(currenbg);
			 $("#columntext p").css("font-size",currenfontsze);
		}
		// FONT SIZES
		// LINE HEIGHT
		if($.trim(name) == 'lh'){						
			var currenlinegh = value;
			//alert(currenbg);
			 $("#columntext p").css("line-height",currenlinegh+'rem');
		}
		// LINE HEIGHT
		/* Font-Size of Heading start */
		if($.trim(name) == 'hfs'){						
			var currenheadfontsze = value;
			$("#columntext p.pubml-section-title").css("font-size",currenheadfontsze);
		}		
		/* Font-Size of Heading end */	
		/* line-height of Heading start */
		if($.trim(name) == 'hlh'){						
			var currenheadlineheight = value;
			$("#columntext p.pubml-section-title").css("line-height",currenheadlineheight);
		}		
		/* line-height of Heading end */		
		/* Font-Size of Sub-Heading start */
		if($.trim(name) == 'sbfs'){						
			var currensubheadfontsze = value;
			$("#columntext p.pubml-subtitle").css("font-size",currensubheadfontsze);
		}		
		/* Font-Size of Sub-Heading end */
		/* line-height of Sub-Heading start */
		if($.trim(name) == 'sblh'){						
			var currensubheadlineheight = value;
			$("#columntext p.pubml-subtitle").css("line-height",currensubheadlineheight);
		}		
		/* Font-Size of Sub-Heading end */
		/* Font-Size and line-height for small print text start */
		if($.trim(name) == 'smfs'){						
			var smallptfontsze = value;
			$("#columntext p.pubml-small-print").css("font-size",smallptfontsze);
		}		
		if($.trim(name) == 'smlh'){						
			var smallptlineheight = value;
			$("#columntext p.pubml-small-print").css("line-height",smallptlineheight);
		}		
		/* Font-Size and line-height for small print text end */
		
		// DROP CAP FONT SIZE
		if($.trim(name) == 'dfs'){						
			var currendfontsze = value;
			//alert(currenbg);
			 $(".pubml-dropcaps").css("font-size",currendfontsze);
		}
		// DROP CAP Line-Height
		if($.trim(name) == 'dlh'){						
			var currendlineheight = value;
			//alert(currenbg);
			 $(".pubml-dropcaps").css("line-height",currendlineheight);
		}

		// DROP CAP LINE HEIGHT
		// TYPE FACE
		if($.trim(name) == 'ff'){						
			var currenfontfam = value;
			//alert(currenbg);
			 $("#columntext p").css("font-family",currenfontfam);
			 $("#columntext h1").css("font-family",currenfontfam);
			 $("#columntext h2").css("font-family",currenfontfam);
			 $("#columntext .smallcaps").css("font-family",currenfontfam);
			 //$(".dropCap").css("font-family",currenfontfam);
			 $("#typefaceid").val(currenfontfam);
			 $("#runningHead").css("font-family",currenfontfam);
		}
		// TYPE FACE		
	}		
}

function getTextWidth()  {
	
	//reset the position of #columntext div
		//alert('// TOP ::'+columntextOffset.top+'// LEFT ::'+columntextOffset.left); // ADDED TESTING
	$("#columntext").offset({top:columntextOffset.top,left:columntextOffset.left});
	
	getCookieSettings();
	setByParameters();
	getColumnCount();
	updatePageNumber();
	currentPage = 1;
		//var calculated = columntextOffset.left - (textWidth-columnGap);// ADDED TESTING
		//alert('// CALCULATED LEFT ::'+calculated); // ADDED TESTING
	//$("#columntext h1").css("margin-bottom","25rem");
	//$("#columntext h1").css("margin-bottom","2.8rem");
	
	if(!loadingNext) {//if we are loading a previous section, shft to show last page
		if(numberOfPages > 1) {//don't bother to shift for single-page chapters
			$("#columntext").offset({top:columntextOffset.top,left:columntextOffset.left - (textWidth-columnWidth)});
			// $("#columntext").offset({top:columntextOffset.top,left:columntextOffset.left - (textWidth-columnGap)});
			currentPage = numberOfPages;//reset current page to display last page of chapter 
			// as we have shifted to show last column
		}
	}
	//if we have a value in the urlhash, we need to advance the correct number of columns
	if((urlhash != "") & (bookMarkedLoaded == false)) {
		$("#columntext").offset({top:columntextOffset.top,left:columntextOffset.left - ((bookMarkedPage - 1) * totalColumnWidth)});
		currentPage = bookMarkedPage;
	}
		
	bookMarkedLoaded = true;//don't pay attention to any more urlhash input - bookmark urls get used only once on load
	//update page number text
	
	runt_control(); // Runt control function
	
	/*--------- jQuery function to convert text with straight quotes to curly/smart quotes. ------------*/
	$('body').curlies();
	setImagesToREM();  // UPDATE ALL THE IMAGES WIDTH TO REM 
	setImageWidthHeight();   // UPDATE ALL THE IMAGES HEIGHT dynamically
} 

//-------UPDATE PAGE NUMBERS---------------------------------------------------------------
function updatePageNumber() {
	
	if((currentPage > 0) & (currentPage <= numberOfPages) ) {//if the page is in a valid range to display
		if(typeof pubMLpaginationTextLeft == 'undefined' || pubMLpaginationTextLeft == '' )
			var pubMLpaginationTextLeft = '';
		if(typeof pubMLpaginationTextRight == 'undefined' || pubMLpaginationTextRight == '' )
			var pubMLpaginationTextRight = '';
			
		$(".pageNumber").text(pubMLpaginationTextLeft + " " + currentPage + " / " + numberOfPages + " " +  pubMLpaginationTextRight);//update page number text in #pageNumber div
	} else {//if currentPage is 0, hide the page number display
		$(".pageNumber").text("");
	}
	hideFootnote();//any time a page changes, hide any active footnotes
	updateURL();//changes the address in the browser address bar for bookmarking
}

//-------UPDATE URL-------------------------------------------------------------------------
//--this changes the address in the browser address bar for bookmarking
function updateURL() {
	if( isNaN(currentChapterIndex)){
		currentChapterIndex = 0;
	}
	window.location.hash = "s=" + currentChapterIndex + "&p=" + currentPage;
	//---http://www.mybook.com#s=1&p=1 appends section and page to the url
	var $bookmarkurl =  createBookmarkLink(true);
	window.history.pushState("", "", $bookmarkurl);
}

//--------FETCH CONTENT WHEN PREV AREA OR LEFT ARROW IS CLICKED----------------------------
function getPrevious() {
	if(!pageTransitionInProgress) {//only accept a page advance when current page transition is finished
		var typeDetermined = false;//FLAG THAT WE HAVE NOT YET DETERMINED THE CONTENT TYPE YET
		if((tocData[currentChapterIndex].type == 'cover') && (!typeDetermined)){// cover always has 1 page
			typeDetermined = true;//NOW FLAG THAT WE DO KNOW THE CONTENT TYPE
			loadPrevSection(); // call next section/article
			//IF WE CALL loadNextSection and type changes, the next conditional will also
			//execute as true and then the next piece of content will load
		}
		if((tocData[currentChapterIndex].type == 'columntext') && (!typeDetermined)){// first check total number of pages
			var targetOffset = $('#columntext').position().left + totalColumnWidth;//store target position to scroll to
			function doWeNeedPrevSection() {
				setTimeout(function(){//set a timer
					pageTransitionInProgress = false;		
				},transitionSpeed);
		
				//set target position as a failsafe in case scroll animation glitches
				//$("#columntext").offset({top:columntextOffset.top,left:targetOffset});
				if(currentPage  < 1)  {// call next section/article
					loadPrevSection();
				}
				updatePageNumber();//update page number text
			}
			typeDetermined = true;
			$("#columntext").animate({left:"+="+totalColumnWidth},transitionSpeed,doWeNeedPrevSection);//move to next page WILL NEED THIS 
			pageTransitionInProgress = true; //set a flag so click can't be recieved while animation in progress
			currentPage--;//increment prev clicks so the script knows we have just moved a page
			hideCover();
			hideNavPanels();//hide any open tab panels;
		}
	}
	// alert('// TOP ::'+columntextOffset.top+'// LEFT ::'+columntextOffset.left); // ADDED TESTING
	// var calculated = columntextOffset.left - (textWidth-columnGap);// ADDED TESTING
	// alert('// CALCULATED LEFT ::'+calculated); // ADDED TESTING
			if(window.location != window.parent.location){
				$("#bookMarker").hide();
		}
		else{
			$("#bookMarker").show();			
		}
}
//--------FETCH CONTENT WHEN NEXT AREA OR RIGHT ARROW IS CLICKED----------------------------
function getNext() {
	if(!pageTransitionInProgress) {//only accept a page advance when current page transition is finished
		var typeDetermined = false;//FLAG THAT WE HAVE NOT YET DETERMINED THE CONTENT TYPE YET
		if((tocData[currentChapterIndex].type == 'cover') && (!typeDetermined)){// cover always has 1 page
			typeDetermined = true;//NOW FLAG THAT WE DO KNOW THE CONTENT TYPE
			loadNextSection(); // call next section/article
			//IF WE CALL loadNextSection and type changes, the next conditional will also
			//execute as true and then the next piece of content will load
		}
		// alert(totalColumnWidth);
		
		if((tocData[currentChapterIndex].type == 'columntext') && (!typeDetermined)){// first check total number of pages
			var targetOffset = $('#columntext').position().left - totalColumnWidth;//store target position to scroll to
			function doWeNeedNextSection() {
				setTimeout(function(){//set a timer
					pageTransitionInProgress = false;		
				},transitionSpeed);
				//set target position as a failsafe in case scroll animation glitches
				//$("#columntext").offset({top:columntextOffset.top,left:targetOffset});
				if(currentPage  >  numberOfPages)  {// call next section/article
					loadNextSection();
				}
				updatePageNumber();//update page number text
			}
			typeDetermined = true;
			$("#columntext").animate({left:"-="+totalColumnWidth},transitionSpeed,doWeNeedNextSection);//move to next page WILL NEED THIS
			pageTransitionInProgress = true; //set a flag so click can't be recieved while animation in progress
			$(".prevPageArea").show();//we are now on a higher page than 1 so show the prevPageArea
			currentPage++;//increment prev clicks so the script knows we have just moved a page
			hideCover();
			hideNavPanels();//hide any open tab panels;   
		}
	}
	// alert('// TOP ::'+columntextOffset.top+'// LEFT ::'+columntextOffset.left); // ADDED TESTING
	// var calculated = columntextOffset.left - (textWidth-columnGap);// ADDED TESTING
	// alert('// CALCULATED LEFT ::'+calculated); // ADDED TESTING
		if(window.location != window.parent.location){
				$("#bookMarker").hide();
		}
		else{
			$("#bookMarker").show();			
		} 
}

//---DOCUMENT READY EVENT-------------
$(document).ready(function(){
	//---looks for a # in the url to see if page is bookmarked-------------
	urlhash = document.URL.substr(document.URL.indexOf('#')+1);
	var book_height = $('#cover').height();
	book_height = book_height - book_height*0.1;
	
	//this puts the scrollbar on the TOC
	$(function(){
		$('#contentspanel').slimScroll({
			// height: '400px',
			size: '8px',
			position: 'right',
			color: '#fff',
			alwaysVisible: true,
			distance: '6px',
			railVisible: false,
			railColor: '#fff',
			railOpacity: 0.2,
			wheelStep: 2
		});
		$('.scroll_panel').slimScroll({
			// height: '400px',
			size: '8px',
			position: 'right',
			color: '#fff',
			alwaysVisible: false,
			distance: '6px',
			railVisible: true,
			railColor: '#fff',
			railOpacity: 0.2,
			wheelStep: 2
		});
		
		$('.scroll_panel').height('auto').css('max-height',book_height);
		$('.slimScrollDiv').height('auto');	
		
	});
	
	//when loading a hash url, initial page count is off
	$(".pageNumber").hide();//so hide the page count display
	setTimeout(function(){//set a timer
		$(".pageNumber").show();//then show the div
		getColumnCount();
		updatePageNumber();//and update the page #		
	},2000);
	
	
	//Google Webfont Loader
	/*WebFontConfig = { google: { families: [ 'Crimson Text','Alegreya','Old Standard TT' ] }};

    (function() {
     var wf = document.createElement('script');
     wf.src = ('https:' == document.location.protocol ? 'https' : 'http') + '://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';
     wf.type = 'text/javascript';
     wf.async = 'true';
     var s = document.getElementsByTagName('script')[0];
     s.parentNode.insertBefore(wf, s);
   })();*/
	
	resizeHotAreas();// size next/prev Areas when document loads
	columntextOffset=$("#columntext").offset();//record  top  and  left  coordinates  of  #columntext  div
	loadTOC(); //load up the tabe of contents  
	/* INITIALLY ALL HOT AREAS OPEN SCRIPT WILL HANDLE LATER CALLS */
	$(".prevPageArea").show();
	$(".nextPageArea").show()
		
/* -------------PREVIOUS PAGE HOT AREA -----------------*/
	$(".prevPageArea").click(function(){
		getPrevious();
	});

/* -------------LEFT ARROW -----------------*/	
	$(document).keydown(function(e){
		if (e.keyCode == 37) { 
		   getPrevious();
		   return false;
		}
	});
/* --------------NEXT PAGE HOT AREA --------------------*/
	$(".nextPageArea").click(function(){
	$("article-img").each(function(){
		var class_attr = jQuery(this).find('img').attr("class");
		var height_attr =  jQuery(this).find('img').height();
		 jQuery(this).addClass(class_attr);
		 jQuery(this).css("min-height",height_attr);
	});
		getNext();
	});

/* -------------RIGHT ARROW -----------------*/		
	$(document).keydown(function(e){
		if (e.keyCode == 39) { 
		   getNext();
		   return false;
		}
	});
		
/*-----------------FOOTNOTES-------------------*/
	$("#footnote").click(function(){
		hideFootnote();//---fade footnotes when the footnotes div is clicked
	});
	
/*----------------SHOW/HIDE THE #test DIV-------------------*/
	if(!testing) {
		$("#test").css("display",'none');
	}
	
/*---------BOOKMARK RIBBON-------------------------*/	
	//show the bookmark ribbon only if index.html is top level page
	if ( window.opera || window.sidebar ) { // add a 'rel' attrib if Op 7+ && Fx >= 23
		var $favLinkAttrRel = $("#bookMarker").attr('rel');
		if ( typeof $favLinkAttrRel == "undefined" || $favLinkAttrRel == false ) { // don't overwrite the rel attr if already set
			$("#bookMarker").attr('rel', 'sidebar');			
		}
	}


	$("#bookMarker").click( function(){
		createBookmarkLink();
	});
	
/*---------IF OFFLINE, HIDE MEDIA FEATURES------------*/
	disableMediaWhenOffline();
});

/* REST OF THE CALLS */

//TEST IF BOOK IS OFFLINE
function disableMediaWhenOffline() {
	if(navigator.offLine) {
	   $("#settingsFontMenu").hide();
	   $("#mediaLinksCheckbox").hide();
	   //$(".media").removeClass("hideMediaLinks").addClass("showMediaLinks");
	} else {
		$("#settingsFontMenu").show();
		$("#mediaLinksCheckbox").show();
		//$(".media").removeClass("showMediaLinks").addClass("hideMediaLinks");
	}
}

//check if book is offline every 15 seconds
var int=self.setInterval(function(){disableMediaWhenOffline()},15000);

//---DYNAMICALLY RESIZE NEXT/PREV HOT AREAS-------
/*this resizes the next and previous page areas when the page loads and when a screen size change is detected*/
function resizeHotAreas(){
	var windowWidth = $(window).width();
	var bookWidth = $("#columntext").width();
	var hotAreaWidth = ((windowWidth - bookWidth)/ 2)-20;
	$(".prevPageArea").css("width",hotAreaWidth);
	$(".nextPageArea").css("width",hotAreaWidth);
}

//--------FOOTNOTES--------------------------------------------------------------------------
function getFootnote(noteName) {
	$("#footnote").hide();
	$("#footnote").load("footnotes/" + footnoteArray[noteName]);//load a footnote into #footnote
	$("#footnote").fadeIn(500);
	setTimeout( function(){
       $('div#footnote footnote_card description').slimScroll({
			height: '18rem',
			size: '8px',
			position: 'right',
			color: '#ccc',
			alwaysVisible: false,
			distance: '6px',
			railVisible: true,
			railColor: '#fff',
			railOpacity: 0.8,
			wheelStep: 2
		});
    },550); 
}

function hideFootnote() {
	$("#footnote").fadeOut(500);
}

// Return the javascript array of found elements
function createJson(array) {
	// The variable results needs var in this case (without 'var' a global variable is created)
	// var results = [];
	var results =  {};	
	var pubml_cookie = ['fs','ff','lh','aln','bg','pbg','fnt','med','dfs','dlh','hfs','hlh','sbfs','sblh','smfs','smlh'];
	
	for (var i = 0; i < array.length; i++) {
		var key_val = array[i].split("=");
		if ( pubml_cookie.indexOf( key_val[0] ) > -1) {
			results[key_val[0]] =  key_val[1] ;	
		}	
	}
	return results;
}


//---------BOOKMARKS----------------------------------------------------------------------------
function createBookmarkLink( urlupdate ){
	if ( ( typeof urlupdate === 'undefined') || ( $.trim(urlupdate) == '' ) )
		urlupdate = false;	// if no paramaters were passed, so the urlupdate is actually false	
		
	var $title = "PubML : " + document.title;
	var myurlindex = document.location.href.split('?')[0];
	var myurlindex = myurlindex.split('#')[0];
	var urlsection = document.location.href.split('#')[1];
	var referer = getParameterByName('referer');		
	
	var allcookies = document.cookie;	
	
	cookiearray  = allcookies.split('; ');
	var cookie_json = createJson(cookiearray);		
	cookie_val_srl = jQuery.param( cookie_json );

	if(typeof referer != 'undefined' && referer != '' ){		
		var url = myurlindex+'?1=1&referer='+referer+'&'+cookie_val_srl+'#'+urlsection;
	}else{
		var url = myurlindex+'?1=1&'+cookie_val_srl+'#'+urlsection;
	}
	
	// return updated url.
	if( urlupdate == true){
		return url;
	}
	
	// IE Favorite
	if ( 'AddFavorite' in window.external ) {
		window.external.AddFavorite(url, $title);
	}
	// Fx <23 Bookmark, 'addPanel' not available from v23 on any more.
	else if ( window.sidebar && ('addPanel' in window.sidebar )) {
		window.sidebar.addPanel($title, url, '');
	}
	// Op 7+ && Fx >= 23
	else if ( window.opera || window.sidebar ) {
		$("#bookMarker").attr('title', $title);
		alert('Your browser doesn\'t support the bookmark functionality, Please add this page to your bookmarks manually.');
		return true; // do nothing - the rel="sidebar" should do the trick
	}
	// for other Browsers
	else if(window.opera && window.print) {
		/* Opera Hotlist */
		alert('Your browser doesn\'t support the bookmark functionality, Please add this page to your bookmarks manually.');
		return true;
	}
	else{
		/* Other Browsers */
		alert('Your browser doesn\'t support the bookmark functionality, Please add this page to your bookmarks manually.');
		return true;
	}

}
//--- Hide Nav Panels EVENT--------------------------------------------------------------------
function hideNavPanels() {
	$(".navpanel").slideUp(100);
	if($(window).width()<500){
		$('#tabs').css('left','-640px');
	}
	
}
//---WINDOW RESIZE EVENT------------------------------------------------------------------------
$(window).resize(function() {
	resizeHotAreas();// can call it any where in this event, even can hold any return value
    setTimeout( function(){
       // window.location = location.pathname;
    },500); 
});